//
//  NaviSettringManager.m
//  NaviDemo
//
//  Created by v_lisisi on 2023/4/24.
//  Copyright © 2023 v_qinruiguang. All rights reserved.
//

#import "NaviSettringManager.h"
#import "BNaviService.h"
@implementation NaviSettringManager

+(void)loadData:(BOOL)isFromLocal {
    // 获取 Documents 目录路径
    NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    NSString *documentsDirectory = [paths objectAtIndex:0];
    // 获取 plist 文件路径
    NSString *filePath = [documentsDirectory stringByAppendingPathComponent:@"LocalNaviSettingConfig.plist"];
    // 读取 plist 文件数据
    NSDictionary *dict = [NSDictionary dictionaryWithContentsOfFile:filePath];
    [NaviSettringManager setNaviSetting:dict fromLocal:isFromLocal];
}

+ (void)setNaviSetting:(NSDictionary *)dict fromLocal:(BOOL)isFromLocal {
    if (!dict) {
        return;
    }
   
    NSDictionary *shortCutDict = dict[@"ShortCutDict"];
    BNaviSettingShortCutModel *cutModel = [[BNaviSettingShortCutModel alloc] init];
    if (isFromLocal) {
        cutModel.hiddenDIYNaviTypes = [shortCutDict[@"hiddenDIYNaviTypes"] boolValue];
        cutModel.hiddenProblemUploadType = [shortCutDict[@"hiddenProblemUploadType"] boolValue];
        cutModel.hiddenYantuSearchType = [shortCutDict[@"hiddenYantuSearchType"] boolValue];
        cutModel.hiddenRoadCondition = [shortCutDict[@"hiddenRoadCondition"] boolValue];
        cutModel.hidden = [shortCutDict[@"hidden"] boolValue];
    }
    
    [BNaviService_NaviSet setShortCutModel: cutModel];

    NSDictionary *showDict = dict[@"ShowDict"];
    BNaviSettingShowModel *showModel = [[BNaviSettingShowModel alloc] init];
    if (isFromLocal) {
        showModel.hidden = [showDict[@"hidden"] boolValue];
        showModel.hiddenSmartScale = [showDict[@"hiddenSmartScale"] boolValue];
        showModel.hiddenNaviPerspective = [showDict[@"hiddenNaviPerspective"] boolValue];
        showModel.hiddenDayNight = [showDict[@"hiddenDayNight"] boolValue];
        showModel.hiddenMapLane = [showDict[@"hiddenMapLane"] boolValue];
        
    }
    
    [BNaviService_NaviSet setShowModel:showModel];
    
    NSDictionary *voiceDict = dict[@"VoiceDict"];
    BNaviSettingVoiceModel *voiceModel = [[BNaviSettingVoiceModel alloc] init];
    if (isFromLocal) {
        voiceModel.hidden = [voiceDict[@"hidden"] boolValue];
        voiceModel.hiddenNaviBroadcastMode = [voiceDict[@"hiddenNaviBroadcastMode"] boolValue];
        voiceModel.hiddenNaviTTSContent = [voiceDict[@"hiddenNaviTTSContent"] boolValue];
    }
    
    [BNaviService_NaviSet setVoiceModel:voiceModel];
    
    NSDictionary *routeDict = dict[@"RouteDict"];
    BNaviSettingRoutePreferenceModel *routeModel = [[BNaviSettingRoutePreferenceModel alloc] init];
    if (isFromLocal) {
        routeModel.hidden = [routeDict[@"hidden"] boolValue];
        routeModel.hiddenRoutePreference = [routeDict[@"hiddenRoutePreference"] boolValue];
    }
    
    [BNaviService_NaviSet setRoadPreferenceModel:routeModel];
    
    NSDictionary *assistDict = dict[@"AssistDict"];
    BNaviSettingAssistModel *assistModel = [[BNaviSettingAssistModel alloc] init];
    if (isFromLocal) {
        assistModel.hidden = [assistDict[@"hidden"] boolValue];
        assistModel.hiddenBlueTooth = [assistDict[@"hiddenBlueTooth"] boolValue];
    }
    
    [BNaviService_NaviSet setAssistModel:assistModel];
}


@end
