//
//  DigitDogViewController.m
//  NaviDemo
//
//  Created by Chen,Xintao on 2019/5/14.
//  Copyright © 2019 Baidu. All rights reserved.
//

#import "DigitDogViewController.h"
#import "BNaviService.h"

@interface DigitDogViewController ()<BNDigitDogManagerDelegate>

@property (weak, nonatomic) UIButton* digitDogButton;

@property (assign, nonatomic) BOOL bStartDigitDogWithoutUI;

@end

@implementation DigitDogViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor = [UIColor whiteColor];
    [self initUI];
}

- (void)viewWillDisappear:(BOOL)animated
{
    [super viewWillDisappear:animated];
    if (self.bStartDigitDogWithoutUI)
    {
        [BNaviService_DigitDog stopDigitDog];
        self.bStartDigitDogWithoutUI = NO;
    }
}

- (UIButton*)createButton:(NSString*)title target:(SEL)selector frame:(CGRect)frame
{
    UIButton* button = [UIButton buttonWithType:UIButtonTypeRoundedRect];
    button.frame = frame;
    [button setTitle:title forState:UIControlStateNormal];
    [button setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    if ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7) {
        [button setBackgroundColor:[UIColor whiteColor]];
    }else
    {
        [button setBackgroundColor:[UIColor clearColor]];
    }
    [button addTarget:self action:selector forControlEvents:UIControlEventTouchUpInside];
    return button;
}


- (void)initUI
{
    CGSize buttonSize = {240,40};
    
    UIButton* button = [self createButton:@"开始无UI电子狗" target:@selector(startOrStopDigitDog:)  frame:CGRectMake(0, 0, buttonSize.width, buttonSize.height)];
    button.center = self.view.center;
    self.digitDogButton = button;
    [self.view addSubview:button];
}

- (void)startOrStopDigitDog:(UIButton*)button
{
    self.bStartDigitDogWithoutUI = !self.bStartDigitDogWithoutUI;
    if (self.bStartDigitDogWithoutUI)
    {
        [button setTitle:@"停止无UI电子狗" forState:UIControlStateNormal];
        BNaviService_DigitDog.delegate = self;
        [BNaviService_DigitDog startDigitDog];
        
    }
    else
    {
         [button setTitle:@"开始无UI电子狗" forState:UIControlStateNormal];
        [BNaviService_DigitDog stopDigitDog];
    }
}

- (void)onLocationClose
{
    NSLog(@"onLocationClose");
}

- (void)onLocationError
{
    NSLog(@"onLocationError");
}

- (void)onStartDigitDog
{
    NSLog(@"onStartDigitDog");
}


- (BOOL)shouldAutorotate {
    return NO;
}

- (UIInterfaceOrientationMask)supportedInterfaceOrientations {
    return UIInterfaceOrientationMaskPortrait;
}

@end
