//
//  CustomSpeedView.m
//  NaviDemo
//
//  Created by v_lisisi on 2024-05-16.
//  Copyright © 2024 v_qinruiguang. All rights reserved.
//

#import "CustomSpeedView.h"
#import "CommonDefine.h"
@interface CustomSpeedView ()

@property (nonatomic, strong) UILabel *speedLab;
@property (nonatomic, strong) UILabel *speedUnitLab;
@property (nonatomic, strong) UIView *baseView;
@end

@implementation CustomSpeedView

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        self.layer.cornerRadius = frame.size.width / 2;
        self.layer.masksToBounds = YES;
        self.backgroundColor = [UIColor whiteColor];
        [self creatUI];
    }
    return self;
}

- (void)creatUI {
    self.baseView = [[UIView alloc] init];
    self.baseView.layer.cornerRadius = 56/2;
    self.baseView.frame = CGRectMake(2, 2, self.frame.size.width-4, self.frame.size.height-4);
    self.baseView.layer.borderWidth = 4;
    self.baseView.layer.borderColor = UIColorFromRGB(0x338DFF).CGColor; //  [UIColor greenColor].CGColor;
    [self addSubview:self.baseView];
    
    self.speedLab = [[UILabel alloc] init];
    self.speedLab.text = @"--";
    self.speedLab.textAlignment = NSTextAlignmentCenter;
    self.speedLab.adjustsFontSizeToFitWidth = YES;
    [self addSubview:self.speedLab];
    self.speedLab.frame = CGRectMake(0, 10, self.frame.size.width, 20);
    
    self.speedUnitLab = [[UILabel alloc] init];
    self.speedUnitLab.text = @"km/h";
    self.speedUnitLab.font = [UIFont systemFontOfSize:10];
    self.speedUnitLab.textAlignment = NSTextAlignmentCenter;
    self.speedUnitLab.adjustsFontSizeToFitWidth = YES;
    [self addSubview:self.speedUnitLab];
    self.speedUnitLab.frame = CGRectMake(0, 32, self.frame.size.width, 10);
    
 
}

-(void)setSpeed:(BNKMNaviSpeed *)speed {
    _speed = speed;
    if (_speed.speed <0) {
        self.speedLab.text = @"--";
    } else {
        self.speedLab.text = [NSString stringWithFormat:@"%d", speed.speed];
    }
    [self superSpeedAnimation];
}
-(void)setSpeedLimit:(int)speedLimit {
    _speedLimit = speedLimit;
    [self superSpeedAnimation];
}

- (void)superSpeedAnimation {
    if (self.speed.speed > self.speedLimit) {
        self.baseView.layer.borderColor = UIColorFromRGB(0xFF335E).CGColor;
    } else {
        self.baseView.layer.borderColor = UIColorFromRGB(0x338DFF).CGColor;
    }
}
@end
