//
//  CustomSateliteView.m
//  NaviDemo
//
//  Created by v_lisisi on 2024-05-20.
//  Copyright © 2024 v_qinruiguang. All rights reserved.
//

#import "CustomSateliteView.h"
#import "CommonDefine.h"
#import "UtilUITool.h"
@interface CustomSateliteView ()

@property (nonatomic, strong) UIImageView *iconImg;
@property (nonatomic, strong) UILabel *lab;

@end

@implementation CustomSateliteView

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        [self creatUI];
    }
    return self;
}

- (void)creatUI  {
    self.lab = [[UILabel alloc] init];
    self.lab.text = @"";
    self.lab.font = [UIFont systemFontOfSize:13];
    self.lab.textAlignment = NSTextAlignmentRight;
    self.lab.adjustsFontSizeToFitWidth = YES;
    [self addSubview:self.lab];
    self.lab.frame = CGRectMake(0, 0, self.frame.size.width-20, self.frame.size.height);
    
    self.iconImg = [[UIImageView alloc] init];
    [self addSubview:self.iconImg];
    self.iconImg.frame = CGRectMake(self.bounds.size.width - 20, 0, 20, 20);
}

- (void)setModel:(BNaviSignalModel *)model {
    _model = model;
    self.lab.text = model.siginalText;
    UIColor *textColor = nil;
    switch (model.state) {
        case BNaviSignalModelState_Tunnel:
        {
            textColor = UIColorFromRGBA(0xffffff, 1);
        }
            break;
        case BNaviSignalModelState_Underground:
        {
            textColor = UIColorFromRGBA(0xffffff, 1);
        }
            break;
        case BNaviSignalModelState_Weak:
        {
            textColor = UIColorFromRGBA(0xf44335, 1);
        }
            break;
        case BNaviSignalModelState_Medium:
        {
            textColor = UIColorFromRGBA(0xfbe000, 1);
        }
            break;
        case BNaviSignalModelState_Strong:
        {
            textColor = UIColorFromRGBA(0x62d336, 1);
        }
            break;
        case BNaviSignalModelState_BDNotHighPrecision:
        {
            textColor = UIColorFromRGBA(0xffffff, 1);
        }
            break;
        case BNaviSignalModelState_BDHighPrecision:
        {
            textColor = UIColorFromRGBA(0xffffff, 1);
        }
            break;
        default:
            break;
    }
    self.lab.textColor = textColor;
    self.iconImg.tintColor = textColor;
    self.iconImg.image =
    [[UtilUITool getImgWithBundleString:model.siginalImgName] imageWithRenderingMode:UIImageRenderingModeAlwaysTemplate];
}
@end
