//
//  CustomRoadConditionsView.m
//  NaviDemo
//
//  Created by v_lisisi on 2024-05-20.
//  Copyright © 2024 v_qinruiguang. All rights reserved.
//

#import "CustomRoadConditionsView.h"
#import "CommonDefine.h"
#import "UtilUITool.h"
@interface CustomRoadConditionsView ()
@property (nonatomic, strong) UIImageView *carView;

@end

@implementation CustomRoadConditionsView


- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        self.backgroundColor = [UIColor whiteColor];
        self.layer.cornerRadius = 5;
        if (!self.carView) {
            self.carView = [[UIImageView alloc] init];
            self.carView.image = [UtilUITool getImgWithBundleString:@"nsdk_rg_ic_carlocal"];
            self.carView.frame = CGRectMake(0, (frame.size.height - 20)/2, 20, 20);
            [self addSubview:self.carView];
            self.carView.layer.cornerRadius = 10;
            self.carView.layer.masksToBounds = YES;
            [self rotateView:self.carView byAngle:M_PI_2];
        }
    }
    return self;
}
- (void)rotateView:(UIView *)view byAngle:(CGFloat)angle {
    view.transform = CGAffineTransformRotate(view.transform, angle);
}
- (void)setData:(NSArray *)data {
    _data = data;
    [self setNeedsDisplay];  // 标记视图需要重新绘制
}

- (void)setCarPro:(CGFloat)carPro {
    _carPro = carPro;
    self.carView.center = CGPointMake(carPro * self.frame.size.width, 0);
}

- (void)drowColor:(CGColorRef)color
   fromPercentage:(CGFloat)fromPercentage
     toPercentage:(CGFloat)toPercentage
        onContext:(CGContextRef)context {
    CGRect rect = CGRectZero;
    rect = CGRectMake(self.bounds.size.width * fromPercentage, 0, self.bounds.size.width * toPercentage, self.bounds.size.height);
        
    
    CGContextAddRect(context, rect);
    CGContextSetFillColorWithColor(context, color);
    CGContextFillRect(context, rect);
    CGContextStrokePath(context);
}

- (void)drawRect:(CGRect)rect {
    CGContextRef currentGraphicsContext = UIGraphicsGetCurrentContext();
    float sumOfAllSegmentValues = 0;
    CGFloat lastPercentage = 0;
    
    for (int i = 0; i < self.data.count; i++) {
        sumOfAllSegmentValues += [[[self.data objectAtIndex:i] objectForKey:@"value"] intValue];
    }

    for (int i = 0; i < self.data.count; ++i) {
        float currentSegmentValue = [[[self.data objectAtIndex:i] objectForKey:@"value"] intValue];
        CGColorRef color          = [[[self.data objectAtIndex:i] objectForKey:@"color"] CGColor];
        float percentage          = currentSegmentValue / sumOfAllSegmentValues;
        
        [self drowColor:color fromPercentage:lastPercentage toPercentage:percentage onContext:currentGraphicsContext];
        lastPercentage += percentage;
    }
}


@end
