//
//  CustomRadarSwitchView.m
//  NaviDemo
//
//  Created by v_lisisi on 2024/7/10.
//  Copyright © 2024 v_qinruiguang. All rights reserved.
//

#import "CustomRadarSwitchView.h"
#import "CommonDefine.h"
#import "UIView+Ext.h"
#import "UIImage+Ext.h"
#import "BNaviService.h"

#define kMaxLevel               21  // 最大比例尺级别
#define kMinLevel               4   // 最小比例尺级别
@interface  CustomRadarSwitchView ()

@property (nonatomic, strong) UIButton *zoomInButton;
@property (nonatomic, strong) UIButton *zoomOutButton;
@property (nonatomic, strong) UIView *lineView;

@end

@implementation CustomRadarSwitchView

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        self.backgroundColor = [UIColor whiteColor];
        [self createZoomInOutButton];
    }
    return self;
}

- (void)createZoomInOutButton {
    if (self.zoomInButton) return;
    _zoomInButton = [[UIButton alloc] initWithFrame:CGRectMake(0, 0, kRAButtonWidth, kRAButtonHeight+0.5)];
    _zoomInButton.exclusiveTouch = YES;
    _zoomInButton.backgroundColor = [UIColor clearColor];
    [_zoomInButton addTarget:self action:@selector(zoomIn:) forControlEvents:UIControlEventTouchUpInside];
    [_zoomInButton setImage:[UIImage imageNamed:@"icon_radar_zoomin"] forState: UIControlStateNormal];
    [_zoomInButton setImage:[UIImage imageNamed:@"icon_radar_zoomin_grey"] forState:UIControlStateDisabled];
    [_zoomInButton addTopShadowLayer];
    [_zoomInButton setBackgroundImage:[UIImage imageWithColor:[UIColor whiteColor]] forState:UIControlStateHighlighted];
    [_zoomInButton setBackgroundImage:[UIImage imageWithColor:[UIColor lightGrayColor]] forState:UIControlStateHighlighted];
    
    _lineView = [[UIView alloc]initWithFrame:CGRectMake(0, kRAButtonHeight, kRAButtonWidth, 0.5)];
    _lineView.backgroundColor = UIColorFromRGB(0xd9d9d9);
    
    _zoomOutButton = [[UIButton alloc] init];
    _zoomOutButton.frame = CGRectMake(0, kRAButtonHeight+1, kRAButtonWidth, kRAButtonHeight);
    _zoomOutButton.exclusiveTouch = YES;
    _zoomOutButton.backgroundColor = [UIColor clearColor];
    [_zoomOutButton addTarget:self action:@selector(zoomOut:) forControlEvents:UIControlEventTouchUpInside];
    [_zoomOutButton setImage:[UIImage imageNamed:@"icon_radar_zoomout"] forState: UIControlStateNormal];
    [_zoomOutButton setImage:[UIImage imageNamed:@"icon_radar_zoomout_grey"] forState:UIControlStateDisabled];
    [_zoomOutButton addBottomShadowLayer];
    [_zoomOutButton setBackgroundImage:[UIImage imageWithColor:[UIColor whiteColor]] forState:UIControlStateHighlighted];
    [_zoomOutButton setBackgroundImage:[UIImage imageWithColor:[UIColor lightGrayColor]] forState:UIControlStateHighlighted];
    
    [self addSubview:_zoomInButton];
    [self addSubview: _zoomOutButton];
    [self addSubview:_lineView];
}

- (void)handleMapLevelChange:(NSInteger)level {
    NSInteger mapLevel = level;
    if (mapLevel <= 0) {
        BMKMapStatus *status = [self.multiMapView getMapStatus];
        mapLevel = status.fLevel;
    }
    
    if (mapLevel >= kMaxLevel) {
        _zoomInButton.enabled = NO;
        _zoomOutButton.enabled = YES;
    } else if (mapLevel <= kMinLevel) {
        _zoomInButton.enabled = YES;
        _zoomOutButton.enabled = NO;
    } else {
        _zoomInButton.enabled = YES;
        _zoomOutButton.enabled = YES;
    }
}

#pragma mark - Action
- (void)zoomIn:(UIButton *)btn {
    [self changeMapLevel:1];
}

- (void)zoomOut:(UIButton *)btn {
    [self changeMapLevel:-1];
}

- (void)changeMapLevel:(int)step {
    BMKMapStatus *status = [self.multiMapView getMapStatus];
    int level = floor(status.fLevel);
    int newLevel = level + step;
    if (newLevel > kMaxLevel) {
        newLevel = kMaxLevel;
    } else if (newLevel < kMinLevel) {
        newLevel = kMinLevel;
    }
    status.fLevel = (double)newLevel;
    [self.multiMapView setMapStatus:status withAnimation:YES];
}

@end
