//
//  CustomNaviViewController.m
//  NaviDemo
//
//  Created by v_lisisi on 2024-04-24.
//  Copyright © 2024 v_qinruiguang. All rights reserved.
//

#import "CustomNaviViewController.h"
#import "BNRoutePlanModel.h"
#import "BNaviService.h"
#import "BNaviModel.h"
#import "BNaviService.h"
#import "BNaviLanesIconModel.h"
#import "BNGuideViewModel.h"
#import "BNaviModel.h"
#import "CustomNaviMainViewController.h"
@interface CustomNaviViewController ()<BNaviModelDelegate, BNNaviRoutePlanDelegate, BNKMapViewDelegate, BNNaviUIManagerDelegate>



@property (nonatomic, strong) UIButton *realNaviButton;
@property (nonatomic, strong) UIButton *showUIMap;
@property (nonatomic, strong) UIButton *showMainMap;

@property (nonatomic, assign) BOOL isRouteSuccess;

@end

@implementation CustomNaviViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor = [UIColor whiteColor];
    [self addView];
    
}


- (void)addView {
    CGSize buttonSize = {240,40};
    CGRect buttonFrame = {(self.view.frame.size.width-buttonSize.width)/2, 80, buttonSize.width,buttonSize.height};
    UIButton* realNaviButton = [self createButton:@"开始无UI导航" target:@selector(realNavi:)  frame:buttonFrame];
    [self.view addSubview:realNaviButton];
    self.realNaviButton = realNaviButton;
    CGRect backBtnFrame = {(self.view.frame.size.width-buttonSize.width)/2, 130, buttonSize.width, buttonSize.height};
    UIButton *backNaviButton = [self createButton:@"退出导航" target:@selector(backNavi)  frame:backBtnFrame];
    [self.view addSubview:backNaviButton];
    
    CGRect multiMapFrame = {(self.view.frame.size.width-buttonSize.width)/2, 180, buttonSize.width, buttonSize.height};
    UIButton* addMultiMap = [self createButton:@"是否展示多实例" target:@selector(addMultiMap)  frame:multiMapFrame];
    [self.view addSubview:addMultiMap];
    
    CGRect showUINaviFrame = {(self.view.frame.size.width-buttonSize.width)/2, 230, buttonSize.width, buttonSize.height};
    UIButton* showUIMap = [self createButton:@"进入有UI导航" target:@selector(showUINavi:)  frame:showUINaviFrame];
    [self.view addSubview:showUIMap];
    self.showUIMap = showUIMap;
    
    
    CGRect showMainMapFrame = {(self.view.frame.size.width-buttonSize.width)/2, 280, buttonSize.width, buttonSize.height};
    UIButton *addMainMap = [self createButton:@"是否展示MapView" target:@selector(addNaviMap)  frame:showMainMapFrame];
    [self.view addSubview:addMainMap];
    self.showMainMap = addMainMap;
    
}

- (void)addMultiMap {
    if (self.realNaviButton.isSelected) {
        [self exitNaviUI];
    }
    CustomNaviMainViewController *vc = [[CustomNaviMainViewController alloc] init];
    [self.navigationController pushViewController:vc animated:YES];
}

- (void)backNavi {
    [self exitNaviUI];
    [self.navigationController popViewControllerAnimated:YES];
}

- (void)realNavi:(UIButton *)sender {
    self.showUIMap.selected = NO;
    sender.selected = !sender.isSelected;
    if (self.isRouteSuccess) {
        NSError *err = [BNaviService_naviCoreLogicManager startNavi:BN_NaviTypeReal extParam:nil];
        if (err.code > 0) {
            NSLog(@"%@",err.userInfo);
        }
    } else {
        [self startNavi];
    }

}

- (void)showUINavi:(UIButton*)sender {
    self.realNaviButton.selected = NO;
    sender.selected = !sender.isSelected;
    if (self.isRouteSuccess) {
        [BNaviService_UI showPage:BNaviUI_NormalNavi delegate:self extParams:@{BNaviUI_NormalNavi_TypeKey:@(BN_NaviTypeReal)}];
    } else {
        [self startNavi];
    }
}

- (void)addNaviMap {
    [self.view addSubview:[BNaviService getInstance].naviMapView];
    
}


- (void)routePlanDidFinished:(NSDictionary *)userInfo {
    self.isRouteSuccess = YES;
    if (self.realNaviButton.isSelected) {
        NSError *err = [BNaviService_naviCoreLogicManager startNavi:BN_NaviTypeReal extParam:nil];
        if (err.code > 0) {
            NSLog(@"%@",err.userInfo);
        }
    }
    
    if (self.showUIMap.isSelected) {
        [BNaviService_UI showPage:BNaviUI_NormalNavi delegate:self extParams:nil];
    }

}

- (void)onHandleNaviViewDidLoad:(UIView *)naviView {
    if (naviView) {
        UIButton* addMultiMap = [self createButton:@"调用无UI退出" target:@selector(exitNaviUI)  frame:CGRectMake(self.view.frame.size.width - 120, 230, 100, 80)];
        addMultiMap.backgroundColor = [UIColor redColor];
        [naviView addSubview:addMultiMap];
    }
    
    
}

- (void)exitNaviUI {
    [BNaviService_naviCoreLogicManager  stopNavi:BN_NaviTypeReal extParam:  nil];
}

- (void)startNavi {
    
    NSMutableArray *nodesArray = [[NSMutableArray alloc]initWithCapacity:2];
    BNRoutePlanNode *startNode = [[BNRoutePlanNode alloc] init];
    startNode.pos = [[BNPosition alloc] init];
    startNode.pos.x = 113.948682;
    startNode.pos.y = 22.530758;
    startNode.pos.eType = BNCoordinate_BaiduMapSDK;
    [nodesArray addObject:startNode];
  
    //终点：腾讯大厦
    BNRoutePlanNode *endNode = [[BNRoutePlanNode alloc] init];
    endNode.pos = [[BNPosition alloc] init];
    //113.941079,22.546103
    endNode.pos.x = 113.941079;
    endNode.pos.y = 22.546103;
    endNode.pos.eType = BNCoordinate_BaiduMapSDK;
    [nodesArray addObject:endNode];
    
    //关闭openURL,不想跳转百度地图可以设为YES
    [BNaviService_RoutePlan setDisableOpenUrl:YES];
    [BNaviService_RoutePlan startNaviRoutePlan:BNRoutePlanMode_Recommend naviNodes:nodesArray time:nil delegete:self userInfo:nil];
     
}
#pragma  mark BNKMapViewDelegate
- (CGPoint)carOffsetFor2DMode {
    return CGPointMake(0, -70);
}

- (CGPoint)carOffsetFor3DMode {
    return CGPointMake(0, -70);
}


- (UIButton*)createButton:(NSString*)title target:(SEL)selector frame:(CGRect)frame {
    UIButton* button = [UIButton buttonWithType:UIButtonTypeRoundedRect];
    button.frame = frame;
    [button setTitle:title forState:UIControlStateNormal];
    [button setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    if ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7) {
        [button setBackgroundColor:[UIColor whiteColor]];
    }else
    {
        [button setBackgroundColor:[UIColor clearColor]];
    }
    [button addTarget:self action:selector forControlEvents:UIControlEventTouchUpInside];
    return button;
}


@end
