//
//  CustomNaviNoUIViewController.m
//  NaviDemo
//
//  Created by v_lisisi on 2024/6/27.
//  Copyright © 2024 v_qinruiguang. All rights reserved.
//

#import "CustomNaviNoUIViewController.h"
#import "BNaviService.h"
#import "BNaviModel.h"
@interface CustomNaviNoUIViewController () <BNNaviRoutePlanDelegate, BNNaviUIManagerDelegate>

@property (nonatomic, strong) UIButton *enterUIButn;
@end

@implementation CustomNaviNoUIViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self creatUI];
    [self startNavi];
}
-(void)creatUI {
    self.view.backgroundColor = [UIColor whiteColor];
    self.title = @"无UI导航";
    
    self.enterUIButn = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.enterUIButn setTitle:@"进入有UI的导航" forState:UIControlStateNormal];
    self.enterUIButn.backgroundColor = [UIColor systemBlueColor];
    [self.enterUIButn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    self.enterUIButn.frame = CGRectMake(20, 100, self.view.bounds.size.width-40, 50);
    [self.view addSubview:self.enterUIButn];
    self.enterUIButn.layer.cornerRadius = 10;
    [self.enterUIButn addTarget:self action:@selector(tapEnterNavi) forControlEvents:UIControlEventTouchUpInside];
    
    self.navigationItem.leftBarButtonItem = [[UIBarButtonItem alloc] initWithTitle:@"<返回" style:UIBarButtonItemStylePlain target:self action:@selector(tapExitNavi)];
}

- (void)tapExitNavi {
    [BNaviService_naviCoreLogicManager stopNavi:self.naviType extParam:nil];
    [self.navigationController popViewControllerAnimated:YES];
}

- (void)tapEnterNavi {
    [BNaviService_UI showPage:BNaviUI_NormalNavi delegate:self extParams:@{BNaviUI_NormalNavi_TypeKey:@(self.naviType)}];
}

- (void)startNavi {
    NSError *err = [BNaviService_naviCoreLogicManager startNavi:self.naviType extParam:nil];
    if (err.code > 0) {
        NSLog(@"%@",err.userInfo);
    }
}
 


@end
