//
//  CustomNaviMainViewController.m
//  NaviDemo
//
//  Created by v_lisisi on 2024-04-30.
//  Copyright © 2024 v_qinruiguang. All rights reserved.
//

#import "CustomNaviMainViewController.h"
#import "BNRoutePlanModel.h"
#import "BNaviService.h"
#import "BNaviModel.h"
#import "BNaviService.h"
#import "BNaviLanesIconModel.h"
#import "BNGuideViewModel.h"
#import "BNaviModel.h"

#import "BNaviExpandGuideModel.h"
#import "CustomGuideMainView.h"
#import "CustomGuideAssistView.h"
#import "CustomEtaView.h"
#import "CustomSpeedView.h"
#import "CustomIntervalSpeedView.h"
#import "CustomRoadConditionsView.h"
#import "BNCarRouteData.h"
#import "CommonDefine.h"
#import "CustomSateliteView.h"
#import "CustomHighwayView.h"
#import "CustomExpandMapView.h"
#import "CustomCountdownTimer.h"
#import "CustomRadarSwitchView.h"
@interface CustomNaviMainViewController ()<BMKMapGestureDelegate, BNaviModelDelegate, BNNaviRoutePlanDelegate, BNKMapViewDelegate, BNNaviUIManagerDelegate>
@property (nonatomic, strong) CustomGuideMainView *guideMainView;
@property (nonatomic, strong) CustomGuideAssistView *guideAssistView;
@property (nonatomic, strong) CustomIntervalSpeedView *intervalSpeedView;
@property (nonatomic, strong) CustomRoadConditionsView *roadCoditionView;
@property (nonatomic, strong) CustomSateliteView *sateliteView;
@property (nonatomic, strong) CustomHighwayView *topHighwayView;
@property (nonatomic, strong) CustomHighwayView *bottomHighwayView;
@property (nonatomic, strong) CustomEtaView *etaView;
@property (nonatomic, strong) CustomExpandMapView *expandMapView;
@property (nonatomic, strong) UILabel *roadNameLabel;
@property (nonatomic, strong) BNKMapView *multiMapView;
@property (nonatomic, strong) CustomSpeedView *speedView;
@property (nonatomic, strong) UIButton *overviewBtn;
@property (nonatomic, strong) UIButton *set2DBtn;
@property (nonatomic, strong) UIButton *mainSlaveButtonView;
@property (nonatomic, strong) UIButton *bridgeButtonView;
@property (nonatomic, strong) UIButton *returnCarPosition;
@property (nonatomic, strong) UIButton *laneBtn;
@property (nonatomic, strong) UIView *multiSubView;
@property (nonatomic, assign) BOOL isRouteSuccess;
@property (nonatomic, copy) NSArray *roadConditionArr;
@property (nonatomic, assign) CGFloat carProgress;
@property (nonatomic, strong) UIButton *backBtn;
@property (nonatomic, strong) CustomCountdownTimer *downTimer;
@property (nonatomic, strong) CustomRadarSwitchView *radarView;
@property (nonatomic, assign) BNRoadType roadType;
@end

@implementation CustomNaviMainViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.view.backgroundColor = [UIColor whiteColor];
    [self addView];
    [[BNaviModel getInstance] addNaviModelListener:self];
    [self startNavi];
    self.downTimer = [[CustomCountdownTimer alloc] initWithTimeInterval:5];
    __weak typeof(self) ws = self;
    self.downTimer.countdownCompletion = ^{
        [ws tapReturnCarPosition:nil];
        [ws.downTimer stop];
    };
}


- (void)startNavi {
    NSError *err = [BNaviService_naviCoreLogicManager startNavi:BN_NaviTypeReal extParam:nil];
    if (err.code > 0) {
        NSLog(@"%@",err.userInfo);
    }
    [self updateRoadCondition];
}


- (void)updateRoadCondition {
    NSMutableArray* barCharViewData =  [[NSMutableArray alloc] init];
    if ([self.roadConditionArr count] >0) {
        int lastIndex = 0;
        int curlength = 0;
        for (int i = 0; i < [self.roadConditionArr count]; i++) {
            BNaviRoadConditionItem *item = self.roadConditionArr[i];
            curlength = item.startPointToCurItemDistance - lastIndex;
            lastIndex = item.startPointToCurItemDistance;
            if (curlength >0) {
                UIColor *color = [self colorForRoadConditionType:item.eRoadConditionType];
                NSDictionary *dic = [NSDictionary dictionaryWithObjectsAndKeys:@(curlength), @"value", color, @"color", @(item.eRoadConditionType), @"type", nil];
                [barCharViewData addObject:dic];
            }
        }
    }
    
    [self.roadCoditionView setData:barCharViewData];
    [self.roadCoditionView setCarPro:self.carProgress];
    
}
/**
 *  GPS速度变化回调
 *
 *  @param speed GPS速度
 */
- (void)onHandleGPSSpeedChange:(BNKMNaviSpeed *)speed speedLimit:(int)speedLimit {
    NSLog(@"%s speed= %d speedLimit %d", __func__, speed.speed, speedLimit);
    self.speedView.speed = speed;
    self.speedView.speedLimit = speedLimit;
    
}

- (void)onHandleIntervalSpeedChange:(BNIntervalSpeedModel *)speedInfoModel {
    NSLog(@"intervalLength:%ld -limitSpeed: %ld- limitAverageSpeed:%ld -limitAreaRemainDist:%ld", speedInfoModel.intervalLength, speedInfoModel.limitSpeed, speedInfoModel.limitAverageSpeed, speedInfoModel.limitAreaRemainDist);
    self.intervalSpeedView.speedModel = speedInfoModel;

}
/**
 *  处理剩余信息
 *
 *  @param remainInfo 剩余信息
 *  -------------------
 *  Interface to handle remain distance and time
 *
 *  @param remainInfo : Information for remain distance and time
 */
- (void)onHandleRemainInfo:(BNaviRemainInfo *)remainInfo {
    NSLog(@"%s remainInfo.remainingTimeModel.timeDescription = %@", __func__, remainInfo.remainingTimeModel.timeDescription);
    self.etaView.remainInfo = remainInfo;
    
}
/**
 *  车标位置进度变化
 */
- (void)onHandleCarProgressChange {
    NSLog(@"%s ", __func__);
    self.carProgress = [[BNaviModel getInstance] getCarProgress];
    [self.roadCoditionView setCarPro:self.carProgress];
}

/// 高速面板
- (void)onHandleHighwayPanelChange:(BNaviHighwayPanelModel *)model {
    NSLog(@"%s model.topModel = %@ model.topModel.disModel.distanceDescription = %@ model.bottomModel.name = %@ model.bottomModel.disModel.distanceDescription = %@", __func__, model.topModel.name, model.topModel.disModel.distanceDescription, model.bottomModel.name, model.bottomModel.disModel.distanceDescription);
    if (model.eAction == BNaviMessage_Action_Invalid) {
        return;
    }
    if (model.eAction == BNaviMessage_Action_Hide) {
        self.topHighwayView.hidden = YES;
        self.bottomHighwayView.hidden = YES;
        return;
    }
    if (model.eAction == BNaviMessage_Action_Show) {
        if (!self.topHighwayView) {
            self.topHighwayView = [[CustomHighwayView alloc] initWithFrame:CGRectMake(self.view.size.width - 100, CGRectGetMinY(self.returnCarPosition.frame) - 135, 100, 60)];
            [self.multiMapView addSubview:self.topHighwayView];
        }
        if (!self.bottomHighwayView) {
            self.bottomHighwayView = [[CustomHighwayView alloc] initWithFrame:CGRectMake(self.view.size.width - 100, CGRectGetMaxY( self.topHighwayView.frame)+5, 100, 60)];
            [self.multiMapView addSubview:self.bottomHighwayView];
        }
        if (model.topModel.remainDist <= 0 ) {
            self.topHighwayView.hidden = YES;
        } else {
            self.topHighwayView.hidden = NO;
        }
        if (model.bottomModel.remainDist <= 0 ) {
            self.bottomHighwayView.hidden = YES;
        } else {
            self.bottomHighwayView.hidden = NO;
        }
    } else {
        
        if (model.topModel.remainDist <= 0 ) {
            self.topHighwayView.model = nil;
            self.topHighwayView.hidden = YES;
        } else {
            self.topHighwayView.model = model.topModel;
            self.topHighwayView.hidden = NO;
        }
        if (model.bottomModel.remainDist <= 0 ) {
            self.bottomHighwayView.model = nil;
            self.bottomHighwayView.hidden = YES;
        } else {
            self.bottomHighwayView.model = model.bottomModel;
            self.bottomHighwayView.hidden = NO;
        }
    }
    
}
/// 红绿灯
- (void)onHandleRemainTrafficlightsInfo:(BNaviRemainTrafficlightsInfo*)remainTrafficlightsInfo {
    NSLog(@"%s remainTrafficlightsInfo  %d", __func__, remainTrafficlightsInfo.remainTrafficights);
    self.etaView.trafficLightsInfo = remainTrafficlightsInfo;
}

///放大图
- (void)onHandleExpandMap:(UIView *)rasterExpandMap guideModel:(BNaviExpandGuideModel *)model {
    NSLog(@"%s rasterExpandMap %@ disModel %@ ", __func__, rasterExpandMap, model.disModel.distanceDescription);
    if (model) {
        [self.expandMapView updateRasterExpandMap:rasterExpandMap];
    }
    [self.expandMapView subViewUpate:model];
}

- (void)onHandleNaviStatusChange:(BNaviStatusInfo*)naviStatusInfo {
    NSLog(@"%s naviStatusInfo %d ", __func__, naviStatusInfo.eNaviSightType);
    if (naviStatusInfo.eNaviStatusType == BNaviStatus_Type_End2) {
        [self tapBack];
    }
    self.multiSubView.hidden = YES;
    self.topHighwayView.hidden = YES;
    self.bottomHighwayView.hidden = YES;
    self.bridgeButtonView.hidden = YES;
    self.mainSlaveButtonView.hidden = YES;
    self.intervalSpeedView.hidden = YES;
}

#pragma mark -- BNaviModelDelegate

/// 驾车诱导面板
- (void)onHandleNewSimpleGuideUIInfo:(BNGuideViewCombinationModel *)model {
    NSLog(@"%s onHandleNewSimpleGuideUIInfo %@ ", __func__, model.mainModel.remainDistDescription);
    if (model) {
        self.guideMainView.mainData = model.mainModel;
        self.guideAssistView.assistData = model.assistModel;
    }
    
    
}
/// 信号
- (void)onHandleSignalStatusChange:(BNaviSignalModel *)model {
    NSLog(@"%s model %@ ", __func__, model.siginalText);
    self.sateliteView.model = model;
}
/// 路名
-(void)onHandleCurrentRoadName:(BNaviCurrentRoadName *)curRoadName {
    NSLog(@"%s curRoadName %@ ", __func__, curRoadName.curRoadName);
    self.roadNameLabel.text = curRoadName.curRoadName;
    if (curRoadName.curRoadName.length>0) {
        self.roadNameLabel.hidden = NO;
    } else {
        self.roadNameLabel.hidden = YES;
    }
     
}

///车道线
- (void)onHandleNaviLaneInfoChanged:(BNaviLaneInfo *)param withLanesIcons:(NSArray<BNaviLanesIconModel*> *)array {
    NSLog(@"%s array %d  param.eAction %d", __func__, array.count, param.eAction);
    if (param.eAction == BNaviMessage_Action_Update || param.eAction ==  BNaviMessage_Action_Show) {
        self.multiSubView.hidden = NO;
    } else {
        self.multiSubView.hidden = YES;
    }
    
    for (UIView *sb in self.multiSubView.subviews) {
        [sb removeFromSuperview];
    }
    CGFloat imgW = 30;
    CGFloat imgH = 50;
    for (int i = 0; i<array.count; i++) {
        UIImageView *imgView = [[UIImageView alloc] init];
        imgView.contentMode =  UIViewContentModeScaleAspectFit;
        BNaviLanesIconModel *model = array[i];
        NSString *imagePath = [[[NSBundle mainBundle] resourcePath] stringByAppendingPathComponent:[NSString stringWithFormat:@"baiduNaviSDK.bundle/image/%@", model.iconStr]];
        UIImage *image = [UIImage imageWithContentsOfFile:imagePath];
        imgView.image = image;
        imgView.frame = CGRectMake((imgW*self.multiSubView.subviews.count), 0, imgW, imgH);
        [self.multiSubView addSubview:imgView];
        if (model.isRecommend) {
            [self startBlinkingAnimation:imgView];
        }
        if (i<array.count - 1) {
            UIImageView *lineImgView = [[UIImageView alloc] init];
            NSString *lineImagePath = [[[NSBundle mainBundle] resourcePath] stringByAppendingPathComponent:[NSString stringWithFormat:@"baiduNaviSDK.bundle/image/%@", [[BNaviModel getInstance] getNaviLanesIcon]]];
            UIImage *lineImg = [UIImage imageWithContentsOfFile:lineImagePath];
            lineImgView.image = lineImg;
            lineImgView.contentMode = UIViewContentModeScaleAspectFit;
            lineImgView.frame = CGRectMake((imgW*(self.multiSubView.subviews.count)), 0, imgW, imgH);
            [self.multiSubView addSubview:lineImgView];
        }
    }

    self.multiSubView.frame = CGRectMake((self.view.width - (self.multiSubView.subviews.count*imgW))/2, CGRectGetMaxY(self.guideAssistView.frame)+10, self.multiSubView.subviews.count*imgW, imgH);
}

- (void)startBlinkingAnimation:(UIView *)view {
    [UIView animateWithDuration:0.5
                          delay:0.0
                        options:UIViewAnimationOptionAutoreverse | UIViewAnimationOptionRepeat
                     animations:^{
                         view.alpha = 0.0;
                     }
                     completion:^(BOOL finished){
                         view.alpha = 1.0;
                     }];
}
///路况更新
- (void)onHandleRoadConditionChange:(BNaviRoadConditionModel *)model {
    self.roadConditionArr = model.roadConditionArray;
    NSLog(@"%s model.roadConditionArray%d", __func__, model.roadConditionArray.count);
    [self updateRoadCondition];
}
/// 导航中主路变化回调
/// @param routeModel 路线数据model
- (void)onHandleDrivingRouteChange:(BNCarRouteModel *)routeModel {
    NSLog(@"onHandleDrivingRouteChange");
    [self updateRoadCondition];
    self.multiSubView.hidden = YES;
    self.topHighwayView.hidden = YES;
    self.bottomHighwayView.hidden = YES;
    self.bridgeButtonView.hidden = YES;
    self.mainSlaveButtonView.hidden = YES;
    self.intervalSpeedView.hidden = YES;
    
//    self.expandMapView.hidden = YES;
}

/*
 *  高架桥，主辅路显示
 *
 *  @param msg
 */
- (void)onHandleMainSlaveViaductChange:(BNaviMainSlaveViaductInfo *)changeInfo {
    self.roadType = [[BNaviModel getInstance] roadTypeFromMapViewType:changeInfo.nChangeType];
    switch (changeInfo.nChangeType) {
        case BN_MAP_VIEW_TYPE_ALL_DISMISS:
        {
            self.bridgeButtonView.hidden = YES;
            self.mainSlaveButtonView.hidden = YES;
        }
        case BN_MAB_VIEW_TYPE_MAIN_ROAD:
        {
            self.bridgeButtonView.hidden = YES;
            self.mainSlaveButtonView.hidden = NO;
            [self.mainSlaveButtonView setSelected:YES];
        }
            break;
        case BN_MAB_VIEW_TYPE_AUXILIARY_ROAD:
        {
            self.mainSlaveButtonView.hidden = NO;
            self.bridgeButtonView.hidden = YES;
            [self.mainSlaveButtonView setSelected:NO];
        }
            break;
        case BN_MAB_VIEW_TYPE_ON_BRIDGE:
        {
            self.mainSlaveButtonView.hidden = YES;
            self.bridgeButtonView.hidden = NO;
            [self.bridgeButtonView setSelected:YES];
        }
            break;
        case BN_MAB_VIEW_TYPE_UNDER_BRIDGE:
        {
            self.mainSlaveButtonView.hidden = YES;
            self.bridgeButtonView.hidden = NO;
            [self.bridgeButtonView setSelected:NO];
        }
            break;
        case BN_MAB_VIEW_TYPE_ON_BRIDGE_MAIN_ROAD:
        {
            self.mainSlaveButtonView.hidden = NO;
            self.bridgeButtonView.hidden = NO;
            [self.mainSlaveButtonView setSelected:YES];
            [self.bridgeButtonView setSelected:YES];
        }
            break;
        case BN_MAB_VIEW_TYPE_ON_BRIDGE_AUXILIARY_ROAD:
        {
            self.mainSlaveButtonView.hidden = NO;
            self.bridgeButtonView.hidden = NO;
            [self.mainSlaveButtonView setSelected:NO];
            [self.bridgeButtonView setSelected:YES];
        }
            break;
        case BN_MAB_VIEW_TYPE_UNDER_BRIDGE_AUXILIARY_ROAD:
        {
            self.mainSlaveButtonView.hidden = NO;
            self.bridgeButtonView.hidden = NO;
            [self.mainSlaveButtonView setSelected:NO];
            [self.bridgeButtonView setSelected:NO];
        }
            
        default:
            break;
    }
    
}
/**
 *  高架桥，主辅路切换结果消息
 *
 *  @param msg 高架桥主辅路切换消息
 */
- (void)onHandleMainSlaveViaductInfoResult:(BNaviMainSlaveViaductMsg *)msg {
    self.mainSlaveButtonView.hidden = YES;
    self.bridgeButtonView.hidden = YES;
}


- (BOOL)beginTouchPoint:(CGPoint)touchPoint mapSatus:(BMKMapStatus *)mapSatus {
    [self onHandleTapMapView];
    return NO;
}

- (BOOL)moveTouchPoint:(CGPoint)touchPoint mapSatus:(BMKMapStatus *)mapSatus {
    [self onHandleTapMapView];
    return NO;
}



-(void)onHandleTapMapView {
    [self.downTimer stop];
    [self.downTimer restart];
}

+ (NSString *)mapViewTag {
    static NSInteger tag = 0;
    tag++;
    return [NSString stringWithFormat:@"mapview_%ld", tag];
}

- (void)addView {
    UIButton *backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [backBtn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    backBtn.titleLabel.font = [UIFont systemFontOfSize:15];
    [backBtn setTitle:@"<返回" forState:UIControlStateNormal];
    [backBtn addTarget:self action:@selector(tapBack) forControlEvents:UIControlEventTouchUpInside];
    backBtn.frame = CGRectMake(0, 0, 50, 50);
    self.navigationItem.leftBarButtonItem = [[UIBarButtonItem alloc] initWithCustomView:backBtn];
    self.multiMapView = [BNaviService_MultMap createNaviMapViewWithTag:[[self class] mapViewTag] withFrame:CGRectMake(0, 0, self.view.bounds.size.width, self.view.bounds.size.height)];
    [self.view addSubview:self.multiMapView];
    self.multiMapView.gestureDelegate = self;
    self.multiMapView.naviMapViewDelegate = self;
    [self.multiMapView setNight:BNaviService_Strategy.realDayNightType == BNDayNight_Type_Night];
    
    self.overviewBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.overviewBtn setTitle:@"全览" forState:UIControlStateNormal];
    [self.overviewBtn setBackgroundColor:UIColorFromRGB(0xFAFAFA)]; //[UIColor orangeColor]];
    self.overviewBtn.titleLabel.font = [UIFont boldSystemFontOfSize:15];
    
    [self.overviewBtn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    [self.overviewBtn addTarget:self action:@selector(tapOverview:) forControlEvents:UIControlEventTouchUpInside];
    self.overviewBtn.frame = CGRectMake(0, self.view.bounds.size.height - 180, 60, 60);
    [self.multiMapView addSubview:self.overviewBtn];
    self.overviewBtn.layer.cornerRadius = 12;
    [self.multiMapView  addUIViewBound:self.overviewBtn.frame];
    
    self.set2DBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.set2DBtn setTitle:@"2d" forState:UIControlStateNormal];
    [self.set2DBtn setTitle:@"3d" forState:UIControlStateSelected];
    [self.set2DBtn setBackgroundColor:UIColorFromRGB(0xFAFAFA)];
    self.set2DBtn.titleLabel.font = [UIFont boldSystemFontOfSize:15];
    
    [self.set2DBtn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    [self.set2DBtn addTarget:self action:@selector(tapSet2dMode:) forControlEvents:UIControlEventTouchUpInside];
    self.set2DBtn.frame = CGRectMake(0, self.view.bounds.size.height - 250, 60, 60);
    [self.multiMapView addSubview:self.set2DBtn];
    self.set2DBtn.selected = YES;
    self.set2DBtn.layer.cornerRadius = 12;
    [self.multiMapView  addUIViewBound:self.set2DBtn.frame];
    self.multiMapView.updateTargetScreenPtWhenMapPaddingChanged = NO;
    [self.multiMapView setMapPadding:UIEdgeInsetsMake(0, 0, self.view.size.height - CGRectGetMidY(self.set2DBtn.frame) + 20, 0)];
    self.returnCarPosition = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.returnCarPosition setBackgroundColor:UIColorFromRGB(0xFAFAFA)];
    [self.returnCarPosition setTitle:@"回车位" forState:UIControlStateNormal];
    self.returnCarPosition.titleLabel.font = [UIFont boldSystemFontOfSize:14];
    [self.returnCarPosition setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    [self.returnCarPosition addTarget:self action:@selector(tapReturnCarPosition:) forControlEvents:UIControlEventTouchUpInside];
    self.returnCarPosition.frame = CGRectMake(self.multiMapView.bounds.size.width - 70, self.multiMapView.bounds.size.height - 180, 60, 60);
    [self.multiMapView addSubview:self.returnCarPosition];
    self.returnCarPosition.layer.cornerRadius = 12;
    [self.multiMapView  addUIViewBound:self.returnCarPosition.frame];
    
    self.laneBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.laneBtn setTitle:@"车道\n级开" forState:UIControlStateNormal];
    [self.laneBtn setTitle:@"车道\n级关" forState:UIControlStateSelected];
    [self.laneBtn setBackgroundColor:UIColorFromRGB(0xFAFAFA)];
    self.laneBtn.titleLabel.font = [UIFont boldSystemFontOfSize:12];
    
    [self.laneBtn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    [self.laneBtn addTarget:self action:@selector(setLaneMulteMap:) forControlEvents:UIControlEventTouchUpInside];
    [self.multiMapView addSubview:self.laneBtn];
    self.laneBtn.layer.cornerRadius = 12;
    self.laneBtn.titleLabel.numberOfLines = 2;
    
    self.multiSubView = [[UIView alloc] init];
    self.multiSubView.hidden = YES;
    self.multiSubView.backgroundColor = [UIColor colorWithRed:0 green:0.48 blue:1 alpha:1];
    
    [self.multiMapView addSubview:self.multiSubView];
    self.multiSubView.layer.cornerRadius = 10;
    self.multiSubView.layer.masksToBounds = YES;
    CGFloat navigationBarHeight = 0.0;

    if (@available(iOS 11.0, *)) {
        UIWindow *window = UIApplication.sharedApplication.keyWindow;
        CGFloat topInset = window.safeAreaInsets.top;
        navigationBarHeight = topInset + self.navigationController.navigationBar.frame.size.height;
    } else {
        navigationBarHeight = self.navigationController.navigationBar.frame.size.height;
    }
     
    self.guideAssistView = [[CustomGuideAssistView alloc] initWithFrame:CGRectMake(0, navigationBarHeight+80, self.view.bounds.size.width, 60)];
    [self.multiMapView addSubview:self.guideAssistView];
    
    self.guideMainView = [[CustomGuideMainView alloc] initWithFrame:CGRectMake(0, navigationBarHeight, self.view.bounds.size.width, 100)];
    [self.multiMapView addSubview:self.guideMainView];
    
    self.multiSubView.frame = CGRectMake(10, navigationBarHeight+150, self.view.bounds.size.width-20, 50);
    [self setMultiMapRouteShowRect];
    
    self.etaView = [[CustomEtaView alloc] initWithFrame:CGRectMake(0, self.multiMapView.frame.size.height - 70, self.multiMapView.frame.size.width, 70)];
    self.etaView.backgroundColor = [UIColor whiteColor];
    [self.multiMapView addSubview:self.etaView];
    
    [self.multiMapView setViewAllMode:YES];
    [self setMultiMapRouteShowRect];
    //--速度码表--/
    self.speedView = [[CustomSpeedView alloc] initWithFrame:CGRectMake(10, CGRectGetMaxY(self.multiSubView.frame), 60, 60)];
    [self.multiMapView addSubview:self.speedView];
    self.intervalSpeedView = [[CustomIntervalSpeedView alloc] initWithFrame:CGRectMake(self.view.size.width - 66, CGRectGetMinY(self.speedView.frame), 60, 120)];
    [self.multiMapView addSubview:self.intervalSpeedView];
    
    CGRect frame = CGRectMake(0, self.etaView.frame.origin.y-10, self.view.frame.size.width, 10);
    self.roadCoditionView = [[CustomRoadConditionsView alloc] initWithFrame:frame];
    [self.multiMapView addSubview:self.roadCoditionView];
    
    self.sateliteView = [[CustomSateliteView alloc] initWithFrame:CGRectMake(self.guideMainView.bounds.size.width-130, 0, 100, 20)];
    [self.guideMainView addSubview:self.sateliteView];
    
    self.expandMapView = [[CustomExpandMapView alloc] initWithFrame:CGRectMake(0, navigationBarHeight, self.view.size.width, 300)];
    
    [self.multiMapView addSubview:self.expandMapView];
    self.roadNameLabel = [[UILabel alloc] init];
    self.roadNameLabel.backgroundColor = [UIColor whiteColor];
    self.roadNameLabel.textAlignment = NSTextAlignmentCenter;
    [self.multiMapView addSubview:self.roadNameLabel];
    self.roadNameLabel.hidden = YES;
    self.roadNameLabel.frame = CGRectMake((self.view.size.width - 200)/2, CGRectGetMinY(self.etaView.frame)-50, 200, 20);
    self.roadNameLabel.layer.cornerRadius = 5;
    self.roadNameLabel.layer.masksToBounds = YES;
    

    self.overviewBtn.frame = CGRectMake(0, CGRectGetMinY(self.etaView.frame)-90, 60, 60);
    self.set2DBtn.frame = CGRectMake(0, CGRectGetMinY(self.overviewBtn.frame)-70, 60, 60);
    self.returnCarPosition.frame = CGRectMake(self.multiMapView.bounds.size.width - 70, CGRectGetMinY(self.etaView.frame)-90, 60, 60);
//    
    self.radarView = [[CustomRadarSwitchView alloc] init];
    self.radarView.multiMapView = self.multiMapView;
    self.radarView.frame = CGRectMake(0, CGRectGetMinY(self.set2DBtn.frame)-kRAButtonHeight*2-5-32, kRAButtonWidth, kRAButtonHeight*2+1);
    [self.multiMapView addSubview:self.radarView];
    
    self.bridgeButtonView = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.bridgeButtonView setTitle:@"切换\n桥上" forState:UIControlStateSelected];
    [self.bridgeButtonView setTitle:@"切换\n桥下" forState:UIControlStateNormal];
    self.bridgeButtonView.titleLabel.numberOfLines = 2;
    [self.bridgeButtonView setBackgroundColor:UIColorFromRGB(0xFAFAFA)]; //[UIColor orangeColor]];
    self.bridgeButtonView.titleLabel.font = [UIFont boldSystemFontOfSize:12];
    
    [self.bridgeButtonView setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    [self.bridgeButtonView setTitleColor:[UIColor blackColor] forState:UIControlStateSelected];
    [self.bridgeButtonView addTarget:self action:@selector(tapBridgeButtonView:) forControlEvents:UIControlEventTouchUpInside];
    self.bridgeButtonView.frame = CGRectMake(self.view.size.width - 70, self.radarView.frame.origin.y, 60, 60);
    [self.multiMapView addSubview:self.bridgeButtonView];
    self.bridgeButtonView.layer.cornerRadius = 12;
    
    self.mainSlaveButtonView = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.mainSlaveButtonView setTitle:@"切换\n主路" forState:UIControlStateSelected];
    [self.mainSlaveButtonView setTitle:@"切换\n辅路" forState:UIControlStateNormal];
    self.mainSlaveButtonView.titleLabel.numberOfLines = 2;
    [self.mainSlaveButtonView setBackgroundColor:UIColorFromRGB(0xFAFAFA)]; //[UIColor orangeColor]];
    self.mainSlaveButtonView.titleLabel.font = [UIFont boldSystemFontOfSize:12];
    
    [self.mainSlaveButtonView setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    [self.mainSlaveButtonView setTitleColor:[UIColor blackColor] forState:UIControlStateSelected];
    [self.mainSlaveButtonView addTarget:self action:@selector(tapMainSlaveButtonView:) forControlEvents:UIControlEventTouchUpInside];
    self.mainSlaveButtonView.frame = CGRectMake(self.view.size.width - 70, self.radarView.frame.origin.y, 60, 60);
    [self.multiMapView addSubview:self.mainSlaveButtonView];
    self.mainSlaveButtonView.layer.cornerRadius = 12;
    
    self.bridgeButtonView.hidden = YES;
    self.mainSlaveButtonView.hidden = YES;
    self.laneBtn.frame = CGRectMake(CGRectGetMaxX(self.set2DBtn.frame)+2, self.set2DBtn.frame.origin.y, 60, 60);
}

-(void)setLaneMulteMap:(UIButton *)sender {
    sender.selected = !sender.selected;
    if (sender.isSelected) {
        [self.multiMapView setSupportLane:NO];
        [self.multiMapView set3DMode];
    } else {
        [self.multiMapView set3DMode];
        [self.multiMapView setSupportLane:YES];
    }
}
///车道级进入和退出消息
-(void)onHandleNavigationMapLaneMsg:(BOOL)isEnter {
    if (!isEnter) {
        self.set2DBtn.selected = YES;
        [self.multiMapView set3DMode];
        
    }
}
- (void)tapBack {
    [self.multiMapView destroyController];
    [BNaviService_naviCoreLogicManager  stopNavi:BN_NaviTypeReal extParam:nil];
    [self.navigationController popViewControllerAnimated:YES];
}

- (void)tapOverview:(UIButton *)sender {
    sender.selected = !sender.isSelected;
    [self setMultiMapRouteShowRect];
    if (sender.isSelected) {
        [sender setTitle:@"退出" forState:UIControlStateNormal];
        [self.multiMapView setViewAllMode:YES];
    } else {
        [sender setTitle:@"全览" forState:UIControlStateNormal];
        [self.multiMapView setViewAllMode:NO];
        [self.multiMapView set3DMode];
    }
}

- (void)tapBridgeButtonView:(UIButton*)sender {
    sender.selected = !sender.isSelected;
    [[BNaviModel getInstance] mapMainSlaveViaductChangeTo:self.roadType];
}

- (void)tapMainSlaveButtonView:(UIButton*)sender {
    sender.selected = !sender.isSelected;
    [[BNaviModel getInstance] mapMainSlaveViaductChangeTo:self.roadType];
}

- (void)setMultiMapRouteShowRect {
    [self.multiMapView setRouteShowRect: UIEdgeInsetsMake(CGRectGetMaxY(self.multiSubView.frame), 10, self.etaView.frame.size.height+40, 10)];
}
    
- (void)tapReturnCarPosition:(UIButton *)sender {
    [self.multiMapView set3DMode];
}

- (void)tapSet2dMode:(UIButton *)sender {
    sender.selected = !sender.isSelected;
    if (sender.isSelected) {
        [self.multiMapView set3DMode];
    } else {
        [self.multiMapView set2DMode];
    }
}

/**
 *  导航中白天黑夜模式变化回调
 *
 *  @param dayNightType 当前白天黑夜模式
 */
- (void)onHandleDayNightTypeChange:(BNDayNight_Type)dayNightType {
    [self.multiMapView setNight:dayNightType == BNDayNight_Type_Night];
    
}
/// 配置地图2D模式车标的偏移量
/// 坐标原点为0,0。
/// x表示横坐标的偏移量，负数往左边移动，正数往右边移动
/// y表示纵坐标的偏移量，负数往下边移动，正数往上边移动
- (CGPoint)carOffsetFor2DMode {
    return CGPointMake(0, -(self.view.bounds.size.height/2.0 - 200));
    
}

/// 配置地图3D模式车标的偏移量
/// 坐标原点为0,0。
/// x表示横坐标的偏移量，负数往左边移动，正数往右边移动
/// y表示纵坐标的偏移量，负数往下边移动，正数往上边移动
- (CGPoint)carOffsetFor3DMode {
    return CGPointMake(0, -(self.view.bounds.size.height/2.0 - 200));
}

- (UIColor *)colorForRoadConditionType:(BNaviRoadCondition_Type_Enum)type {
    UIColor *color = NOROADCONDITION_COLOR;
    switch (type) {
        case BNaviRoadCondition_Type_Straightway:
            color =  STRAIGHTWAY_COLOR;
            break;
        case BNaviRoadCondition_Type_Slow:
            color =  SLOW_COLOR;
            break;
        case BNaviRoadCondition_Type_Obstruction:
            color = OBSTRUCTION_COLOR;
            break;
        case BNaviRoadCondition_Type_VeryObstruction:
            color = VERY_OBSTRUCTION_COLOR;
            break;
        default:
            break;
    }
    return color;
}
@end
