//
//  CustomIntervalSpeedView.m
//  NaviDemo
//
//  Created by v_lisisi on 2024-05-18.
//  Copyright © 2024 v_qinruiguang. All rights reserved.
//

#import "CustomIntervalSpeedView.h"

@interface CustomIntervalSpeedView ()

@property (nonatomic, strong) UILabel *intervalSpeedLab;
@property (nonatomic, strong) UILabel *limtLab;
@property (nonatomic, strong) UILabel *residueDistLab;
@end


@implementation CustomIntervalSpeedView



- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        self.layer.cornerRadius = 25;
        self.layer.masksToBounds = YES;
        self.backgroundColor = [UIColor whiteColor];
        [self creatUI];
        self.hidden = YES;
    }
    return self;
}

- (void)creatUI {
    
    self.intervalSpeedLab = [[UILabel alloc] init];
    self.intervalSpeedLab.text = @"\n平均速度";
    self.intervalSpeedLab.font = [UIFont systemFontOfSize:13];
    self.intervalSpeedLab.numberOfLines = 2;
    self.intervalSpeedLab.textAlignment = NSTextAlignmentCenter;
    self.intervalSpeedLab.adjustsFontSizeToFitWidth = YES;
    [self addSubview:self.intervalSpeedLab];
    self.intervalSpeedLab.frame = CGRectMake(0, 10, self.frame.size.width, 30);
    
    self.limtLab = [[UILabel alloc] init];
    self.limtLab.text = @"0\n限速";
    self.limtLab.font = [UIFont systemFontOfSize:13];
    self.limtLab.numberOfLines = 2;
    self.limtLab.textAlignment = NSTextAlignmentCenter;
    self.limtLab.adjustsFontSizeToFitWidth = YES;
    [self addSubview:self.limtLab];
    self.limtLab.frame = CGRectMake(0, 45, self.frame.size.width, 30);
    
    self.residueDistLab = [[UILabel alloc] init];
    self.residueDistLab.text = @"\n剩余距离";
    self.residueDistLab.font = [UIFont systemFontOfSize:13];
    self.residueDistLab.textAlignment = NSTextAlignmentCenter;
    self.residueDistLab.adjustsFontSizeToFitWidth = YES;
    self.residueDistLab.numberOfLines = 2;
    [self addSubview:self.residueDistLab];
    self.residueDistLab.frame = CGRectMake(0, 75, self.frame.size.width, 30);
    
}

- (void)setSpeedModel:(BNIntervalSpeedModel *)speedModel {
    _speedModel = speedModel;
    if (speedModel.state != BNIntervalSpeedModelStateHide) {
        self.hidden = NO;
        self.intervalSpeedLab.text = [NSString stringWithFormat:@"%d\n平均速度", speedModel.limitAverageSpeed];
        self.limtLab.text = [NSString stringWithFormat:@"%d\n限速", speedModel.limitSpeed];
        if (speedModel.limitAreaRemainDistModel.mValue != -1) {
            self.residueDistLab.text = [NSString stringWithFormat:@"%.0f\n剩余米", speedModel.limitAreaRemainDistModel.mValue];
        } else {
            self.residueDistLab.text = [NSString stringWithFormat:@"%.1f\n剩余公里", speedModel.limitAreaRemainDistModel.kmValue];
        }
        
    } else {
        self.hidden = YES;
    }
    
}


@end
