//
//  CustomHighwayView.m
//  NaviDemo
//
//  Created by v_lisisi on 2024-05-23.
//  Copyright © 2024 v_qinruiguang. All rights reserved.
//

#import "CustomHighwayView.h"
#import "UtilUITool.h"
#import "CommonDefine.h"
@interface CustomHighwayView ()

@property (nonatomic, strong) UIView *typeListView;

@property (nonatomic, strong) UILabel *nameLabel;

@property (nonatomic, strong) UILabel *disLabel;

@end


@implementation CustomHighwayView

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        [self creatUI];
    }
    return self;
}

- (void)creatUI {
    self.layer.cornerRadius = 5;
    self.layer.masksToBounds = YES;
    self.typeListView = [[UIView alloc] init];
    [self addSubview:self.typeListView];
    
    self.nameLabel = [[UILabel alloc] init];
    self.nameLabel.textColor = [UIColor whiteColor];
    self.nameLabel.font = [UIFont systemFontOfSize:15];
    [self addSubview:self.nameLabel];
    
    self.disLabel = [[UILabel alloc] init];
    self.disLabel.textColor = [UIColor whiteColor];
    self.disLabel.font = [UIFont systemFontOfSize:15];
    [self addSubview:self.disLabel];
    
    self.typeListView.frame = CGRectMake(0, 0, self.frame.size.width, 20);
    self.nameLabel.frame = CGRectMake(0, 22, self.frame.size.width, 19);
    self.disLabel.frame = CGRectMake(0, 40, self.frame.size.width, 20);
}

-(void)setModel:(BNaviHighwayContentModel *)model {
    _model = model;
    if (model.highwayInfoType == BNaviHighwayInfoServiceArea ||
       model.highwayInfoType == BNaviHighwayInfoChargeStation||
       model.highwayInfoType == BNaviHighwayInfoSAWithCS) {
        self.backgroundColor = UIColorFromRGB(0x2E8B57);
    } else {
        self.backgroundColor = UIColorFromRGB(0x0063FF);
    }
    for (UIView *subview in self.typeListView.subviews) {
        [subview removeFromSuperview];
    }
    CGFloat x = 18;
    for (int i = 0; i<model.typeIconStrArray.count; i++) {
        UIImageView *img = [[UIImageView alloc] init];
        img.image = [UtilUITool getImgWithBundleString:model.typeIconStrArray[i]];
        [self.typeListView addSubview:img];
        img.frame = CGRectMake(x * i, 0, 18, 18);
    }
    if (model.typeIconStrArray.count == 0) {
        self.nameLabel.frame = CGRectMake(0, 0, self.frame.size.width, 19);
        self.disLabel.frame = CGRectMake(0, 20, self.frame.size.width, 20);
        self.height = 40;
    } else {
        self.nameLabel.frame = CGRectMake(0, 22, self.frame.size.width, 19);
        self.disLabel.frame = CGRectMake(0, 40, self.frame.size.width, 20);
        self.height = 60;
    }
    
    self.nameLabel.text = model.name;
    self.disLabel.text = model.disModel.distanceDescription;
    
}


@end
