//
//  CustomGuideAssistView.m
//  NaviDemo
//
//  Created by v_lisisi on 2024-05-14.
//  Copyright © 2024 v_qinruiguang. All rights reserved.
//

#import "CustomGuideAssistView.h"
#import "UtilUITool.h"
#import "CommonDefine.h"
@interface CustomGuideAssistView ()
@property (nonatomic, strong) UIView *guideView;
@property (nonatomic, strong) UILabel *afterLab;
@property (nonatomic, strong) UIImageView *afterImgView;
@property (nonatomic, strong) UILabel *afterRouteNameLab;

@end

@implementation CustomGuideAssistView


- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        [self addUIView];
    }
    return self;
}

- (void)addUIView {
    
    self.guideView = [[UIView alloc] init];
    self.guideView.backgroundColor = [UIColor systemOrangeColor];
    [self addSubview:self.guideView];
    
    self.afterLab = [[UILabel alloc] init];
    self.afterLab.text = @"随后";
    self.afterLab.textColor = [UIColor whiteColor];
    [self.guideView addSubview:self.afterLab];
    
    self.afterImgView = [[UIImageView alloc] init];
    [self.guideView addSubview:self.afterImgView];
    
    self.afterRouteNameLab = [[UILabel alloc] init];
    self.afterRouteNameLab.text = @"进入";
    self.afterRouteNameLab.textColor = [UIColor whiteColor];
    [self.guideView addSubview:self.afterRouteNameLab];
    self.guideView.hidden = YES;
    [self setUIFrame];
}

- (void)setUIFrame {
    self.guideView.frame = CGRectMake(20, 0, self.bounds.size.width-40, self.bounds.size.height);
    self.afterLab.frame = CGRectMake(10, 30, 50, 20);
    self.afterImgView.frame = CGRectMake(60, 20, 40, 40);
    self.afterRouteNameLab.frame = CGRectMake(110, 30, self.guideView.bounds.size.width - 110, 20);
    [self addBottomLeftAndRightCornersToView:self.guideView withRadius:10];
}
// 添加顶部左右圆角的方法
- (void)addBottomLeftAndRightCornersToView:(UIView *)view withRadius:(CGFloat)radius {
    UIBezierPath *path = [UIBezierPath bezierPathWithRoundedRect:view.bounds
                                               byRoundingCorners:(UIRectCornerBottomLeft | UIRectCornerBottomRight)
                                                     cornerRadii:CGSizeMake(radius, radius)];
    CAShapeLayer *maskLayer = [[CAShapeLayer alloc] init];
    maskLayer.frame = view.bounds;
    maskLayer.path = path.CGPath;
    view.layer.mask = maskLayer;
}
- (void)setAssistData:(BNGuideViewAssistModel *)assistData {
    _assistData = assistData;
    if ([assistData isKindOfClass:[BNGuideViewNoneAssistModel class]]) {
        self.guideView.hidden = YES;
    } else if ([assistData isKindOfClass:[BNGuideViewNextTurnAssistModel class]]) {
        self.guideView.hidden = NO;
        BNGuideViewNextTurnAssistModel *model = (BNGuideViewNextTurnAssistModel*)assistData;
        if (model.highFastExitMode) {
            self.guideView.backgroundColor = UIColorFromRGB(0x0B8455); //[UIColor colorWithRed:46/255.0 green:139/255.0 blue:87/255.0 alpha:1];
        } else {
            self.guideView.backgroundColor = UIColorFromRGB(0x2B3649);
        }
        self.afterLab.text = model.contentAssistModel.nextTurnStr;
        self.afterImgView.image =  [UtilUITool getImgWithBundleString:model.contentAssistModel.nextTurnIconStr];
        self.afterRouteNameLab.text = [NSString stringWithFormat:@"%@ %@", model.contentAssistModel.cohesiveWord, model.contentAssistModel.supplementWord];
    } else {
        self.guideView.hidden = YES;
    }
}

@end
