//
//  CustomExpandMapView.m
//  NaviDemo
//
//  Created by v_lisisi on 2024-05-28.
//  Copyright © 2024 v_qinruiguang. All rights reserved.
//

#import "CustomExpandMapView.h"
#import "UtilUITool.h"
#import "CommonDefine.h"
#import "UILabel+Ext.h"
@interface CustomExpandMapView ()

@property (nonatomic, strong) UIView *expView;

@property (nonatomic, strong) UIImageView *rasterExpandMap;

@property (nonatomic, strong) UIView *progressView;

@property (nonatomic, strong) UIView *progressBgView;

@property (nonatomic, strong) UILabel *remainDist;
@property (nonatomic, strong) UIImageView  *midTurnImage;
@property (nonatomic, strong) UILabel *exitRoad;
@property (nonatomic, strong) UILabel *roadName;
@property (nonatomic, strong) UILabel *nextTurnStr;
@property (nonatomic, strong) UIImageView *nextTurnImage;
@end

@implementation CustomExpandMapView

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        self.backgroundColor = [UIColor clearColor];
        [self addUIView];
    }
    return self;
}

-(void)addUIView {
    self.expView = [[UIView alloc] init];
    self.expView.frame  = CGRectMake(0, 0, self.bounds.size.width, self.bounds.size.height);
    [self addSubview:self.expView];
    
    self.rasterExpandMap = [[UIImageView alloc] init];
    self.rasterExpandMap.frame  = CGRectMake(0, 0, self.bounds.size.width, self.bounds.size.height);
    [self.expView addSubview:self.rasterExpandMap];
    
    self.progressView = [[UIView alloc] init];
    self.progressView.hidden = YES;
    self.progressView.backgroundColor = UIColorFromRGB(0x232830);
    self.progressView.frame  = CGRectMake(0, 0, self.bounds.size.width, 40);
    [self addSubview:self.progressView];
    
    self.progressBgView = [[UILabel alloc] init];
    self.progressBgView.backgroundColor = UIColorFromRGB(0x1ba97f);
    [self.progressView addSubview:self.progressBgView];
    
    self.remainDist = [[UILabel alloc] init];
    self.remainDist.textColor = [UIColor whiteColor];
    [self.progressView addSubview:self.remainDist];
    
    self.midTurnImage = [[UIImageView alloc] init];
    [self.progressView addSubview:self.midTurnImage];
    
    self.exitRoad = [[UILabel alloc] init];
    self.exitRoad.textColor = [UIColor whiteColor];
    [self.progressView addSubview:self.exitRoad];
    
    self.roadName = [[UILabel alloc] init];
    self.roadName.textColor = [UIColor whiteColor];
    [self.progressView addSubview:self.roadName];
    
    self.nextTurnStr = [[UILabel alloc] init];
    self.nextTurnStr.textColor = [UIColor whiteColor];
    [self.progressView addSubview:self.nextTurnStr];
    
    self.nextTurnImage = [[UIImageView alloc] init];
    [self.progressView addSubview:self.nextTurnImage];
    
    self.progressBgView.frame = CGRectMake(0, 0, self.bounds.size.width, 40);
    [self updateSubViewFrame];
}

- (void)updateRasterExpandMap:(UIView *)v {
    if (v && [v isKindOfClass:[UIView class]]) {
        UIImage *img = [self screenshotView:v];
        self.rasterExpandMap.image = img;
    }
    
}

- (void)subViewUpate:(BNaviExpandGuideModel *)model {
    if (model) {
        self.expView.hidden = NO;
        if (model.progress != 1) {
            self.progressBgView.frame = CGRectMake(0, 0, model.progress*self.width, 40);
        } else {
            self.progressBgView.frame = CGRectMake(0, 0, self.width, 40);
        }
        self.remainDist.text = [NSString stringWithFormat:@"%@", model.disModel.distanceDescription];
        UIImage *midTurnImage = [UtilUITool getImgWithBundleString:model.midTurnImageStr];
        self.midTurnImage.image = midTurnImage;
        self.exitRoad.text = model.exitRoad;
        self.roadName.text = model.roadName;
        self.nextTurnStr.text = model.nextTurnStr;
        UIImage *nextTurnImg = [UtilUITool getImgWithBundleString:model.nextTurnImageStr];
        self.nextTurnImage.image = nextTurnImg;
        self.progressView.hidden = NO;
        [self updateSubViewFrame];
    } else {
        self.expView.hidden = YES; 
        self.remainDist.text = @"";
        self.midTurnImage.image = nil;
        self.exitRoad.text = @"";
        self.roadName.text = @"";
        self.nextTurnStr.text = @"";
        self.nextTurnImage.image = nil;
        self.progressView.hidden = YES;
    }
}

- (void)updateSubViewFrame {
    CGFloat top = 10;
    CGFloat height = 20;
    CGFloat space = 3;
    CGFloat imgWidth = 20;
    
    self.remainDist.frame = CGRectMake(0, top, [self getTextWidth:self.remainDist], height);
    self.midTurnImage.frame = CGRectMake(CGRectGetMaxX(self.remainDist.frame)+space, top, imgWidth, height);
    self.exitRoad.frame = CGRectMake(CGRectGetMaxX(self.midTurnImage.frame)+space, top, [self getTextWidth:self.exitRoad], height);
    self.roadName.frame = CGRectMake(CGRectGetMaxX(self.exitRoad.frame)+space, top, [self getTextWidth:self.roadName], height);
    self.nextTurnStr.frame = CGRectMake(CGRectGetMaxX(self.roadName.frame)+space, top, [self getTextWidth:self.nextTurnStr], height);
    self.nextTurnImage.frame = CGRectMake(CGRectGetMaxX(self.nextTurnStr.frame)+space, top, imgWidth, height);
}

- (CGFloat)getTextWidth:(UILabel *)lab {
    CGFloat maxWidth = 200.0; // 设定最大宽度
    return [lab getTextWidth:maxWidth];
}


- (UIImage *)screenshotView:(UIView *)viewToScreenshot {
    // 开始截图
    UIGraphicsBeginImageContextWithOptions(viewToScreenshot.bounds.size, NO, [UIScreen mainScreen].scale);
    // 将指定的视图的内容绘制到当前图形上下文中
    [viewToScreenshot drawViewHierarchyInRect:viewToScreenshot.bounds afterScreenUpdates:YES];
    // 从当前图形上下文中获取截图
    UIImage *screenshot = UIGraphicsGetImageFromCurrentImageContext();
    // 结束图形上下文
    UIGraphicsEndImageContext();
    return screenshot;
}


@end
