//
//  CustomEtaView.m
//  NaviDemo
//
//  Created by v_lisisi on 2024-05-16.
//  Copyright © 2024 v_qinruiguang. All rights reserved.
//

#import "CustomEtaView.h"

@interface CustomEtaView ()
 
@property (nonatomic, strong) UILabel *distanceLab;

@property (nonatomic, strong) UILabel *timeLeftLab;
@property (nonatomic, strong) UIView *bottomView;
@property (nonatomic, strong) UIView *topView;

@property (nonatomic, copy) NSString *disStr;

@property (nonatomic, copy) NSString *timeLeftStr;

@end

@implementation CustomEtaView

 
-(instancetype)initWithFrame:(CGRect)frame {
   self = [super initWithFrame:frame];
    if (self ) {
        [self creatUI];
    }
    return self;
}

- (void)creatUI {
    // 创建顶部视图，包含剩余距离和红绿灯数量
    UIView *topView = [[UIView alloc] init];
    topView.translatesAutoresizingMaskIntoConstraints = NO;
    self.distanceLab = [[UILabel alloc] init];
    self.distanceLab.translatesAutoresizingMaskIntoConstraints = NO;
    [self.distanceLab setContentHuggingPriority:UILayoutPriorityRequired forAxis:UILayoutConstraintAxisHorizontal];
    [self.distanceLab setContentCompressionResistancePriority:UILayoutPriorityRequired forAxis:UILayoutConstraintAxisHorizontal];
    self.distanceLab.text = @"";
    self.distanceLab.textAlignment = NSTextAlignmentRight;
    self.distanceLab.font = [UIFont boldSystemFontOfSize:17];
    self.distanceLab.textAlignment = NSTextAlignmentCenter;
    [topView addSubview:self.distanceLab];
    self.topView = topView;
  
    
    // 创建底部视图，包含剩余时间
    UIView *bottomView = [[UIView alloc] init];
    bottomView.translatesAutoresizingMaskIntoConstraints = NO;
//    bottomView.backgroundColor = [UIColor orangeColor];
    // 添加剩余时间的UILabel等UI元素到bottomView中
    self.bottomView = bottomView;
    self.timeLeftLab = [[UILabel alloc] init];
    self.timeLeftLab.font = [UIFont boldSystemFontOfSize:15];
    self.timeLeftLab.translatesAutoresizingMaskIntoConstraints = NO;
    self.timeLeftLab.text = @"";
    [bottomView addSubview:self.timeLeftLab];
    
    // 创建水平堆栈视图，将顶部视图和底部视图放置在一起
    UIStackView *stackView = [[UIStackView alloc] init];
    stackView.translatesAutoresizingMaskIntoConstraints = NO;
    stackView.axis = UILayoutConstraintAxisVertical;
    stackView.alignment = UIStackViewAlignmentFill;
    stackView.distribution = UIStackViewDistributionFillEqually;
    [stackView addArrangedSubview:topView];
    [stackView addArrangedSubview:bottomView];
    
    [self addSubview:stackView];

    // 设置distanceLab和trafficLightLab的约束
    [self.distanceLab setTranslatesAutoresizingMaskIntoConstraints:NO];
   

    [NSLayoutConstraint activateConstraints:@[
        // distanceLab的约束
        [self.distanceLab.leadingAnchor constraintEqualToAnchor:topView.leadingAnchor constant:8],
        [self.distanceLab.centerYAnchor constraintEqualToAnchor:topView.centerYAnchor],
        [self.distanceLab.widthAnchor constraintEqualToAnchor:topView.widthAnchor multiplier:1 constant:-8],
    ]];


    // 设置timeLeftLab的约束
    [NSLayoutConstraint activateConstraints:@[
        [self.timeLeftLab.centerXAnchor constraintEqualToAnchor:bottomView.centerXAnchor],
        [self.timeLeftLab.centerYAnchor constraintEqualToAnchor:bottomView.centerYAnchor]
    ]];

    // 设置垂直堆栈视图的约束
    [NSLayoutConstraint activateConstraints:@[
        [stackView.topAnchor constraintEqualToAnchor:self.topAnchor],
        [stackView.leadingAnchor constraintEqualToAnchor:self.leadingAnchor],
        [stackView.trailingAnchor constraintEqualToAnchor:self.trailingAnchor],
        [stackView.bottomAnchor constraintEqualToAnchor:self.bottomAnchor]
    ]];

}

-(void)setRemainInfo:(BNaviRemainInfo *)remainInfo {
    _remainInfo = remainInfo;
    BNaviTimeDescriptionModel *model = remainInfo.remainingTimeModel; ///[BNDateDistanceDescriptionTool remainingTimeForETA:remainInfo.remainTime];
    NSLog(@"setRemainInfo %d:%d", model.hour, model.minute);
    
    BNaviTimeDescriptionModel *etaModel = remainInfo.estimatedArrivalTimeModel; //[BNDateDistanceDescriptionTool estimatedArrivalTime:remainInfo.remainTime];
    NSLog(@"setRemainInfo etaModel.hour= %d etaModel.min= %d etaModel.dayType =%lu", model.hour, model.minute, (unsigned long)model.dayType);
    BNaviDistanceDescriptionModel *distStr = remainInfo.etaRemainingDistanceModel; //[BNDateDistanceDescriptionTool etaRemainingDistance:remainInfo.remainDist];
    self.disStr = distStr.distanceDescription;
    self.timeLeftStr = model.timeDescription;
    self.timeLeftLab.text = [NSString stringWithFormat:@"%@到达", etaModel.timeDescription];
    [self setDistanceLabText];

}

- (void)setTrafficLightsInfo:(BNaviRemainTrafficlightsInfo *)trafficLightsInfo {
    _trafficLightsInfo = trafficLightsInfo;
    [self setDistanceLabText];
}

-(void)setDistanceLabText {
    NSString *str = @"";
    if (_remainInfo.etaRemainingDistanceModel.distanceDescription.length>0) {
        str = [str stringByAppendingString:[NSString stringWithFormat:@"%@ %@", _remainInfo.etaRemainingDistanceModel.distanceDescription, _remainInfo.remainingTimeModel.timeDescription]];
    }
    
    if (_trafficLightsInfo.remainTrafficights>0) {
        str = [str stringByAppendingString:[NSString stringWithFormat:@" 红绿灯 终点:%ld", _trafficLightsInfo.remainTrafficights]];
    }
    if (_trafficLightsInfo.viaRemainTrafficights>0) {
        str = [str stringByAppendingString:[NSString stringWithFormat:@"途径点:%ld", _trafficLightsInfo.viaRemainTrafficights]];
    }
    self.distanceLab.text = str;
}

@end
