//
//  CustomCountdownTimer.m
//  NaviDemo
//
//  Created by v_lisisi on 2024/6/3.
//  Copyright © 2024 v_qinruiguang. All rights reserved.
//

#import "CustomCountdownTimer.h"

@interface CustomCountdownTimer () {
    NSTimer *_timer;
    NSTimeInterval _remainingTime;
}

@end

@implementation CustomCountdownTimer

- (instancetype)initWithTimeInterval:(NSTimeInterval)timeInterval {
    self = [super init];
    if (self) {
        _remainingTime = timeInterval;
        _timer = [NSTimer scheduledTimerWithTimeInterval:15.0 target:self selector:@selector(updateTimer:) userInfo:nil repeats:YES];
        _isRunning = YES;
    }
    return self;
}

- (void)updateTimer:(NSTimer *)timer {
    _remainingTime -= 15.0;
    NSLog(@"Remaining Time: %.0f seconds", _remainingTime);
    
    if (_remainingTime <= 0) {
        [_timer invalidate];
        _isRunning = NO;
        NSLog(@"Countdown Finished!");
        if (self.countdownCompletion) {
            self.countdownCompletion();
        }

    }
}

- (void)stop {
    [_timer invalidate];
    _isRunning = NO;
}

- (void)restart {
    _timer = [NSTimer scheduledTimerWithTimeInterval:15.0 target:self selector:@selector(updateTimer:) userInfo:nil repeats:YES];
    _isRunning = YES;
}

@end
