//
//  SearchPoiListViewController.m
//  NaviDemo
//
//  Created by v_lisisi on 2024/6/27.
//  Copyright © 2024 v_qinruiguang. All rights reserved.
//

#import "SearchPoiListViewController.h"
#import "SearchPoiListCellModel.h"
#import "SearchPoiListCell.h"

#import <BaiduMapAPI_Base/BMKBaseComponent.h>
#import <BaiduMapAPI_Search/BMKSearchComponent.h>

@interface SearchPoiListViewController ()<UITableViewDataSource, UITableViewDelegate, UITextFieldDelegate, BMKSuggestionSearchDelegate>
@property (nonatomic, strong) UITextField *cityTextField;
@property (nonatomic, strong) UITextField *textField;
@property (nonatomic, strong) UIButton *searchBtn;
@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) NSMutableArray<SearchPoiListCellModel *> *cellDataArray;
@property (nonatomic, strong) BMKSuggestionSearch *search;
@end

@implementation SearchPoiListViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor = [UIColor whiteColor];
    // 获取状态栏和导航栏的总高度
    CGFloat statusBarHeight = [UIApplication sharedApplication].statusBarFrame.size.height;
    CGFloat navigationBarHeight = self.navigationController.navigationBar.frame.size.height;
    CGFloat topOffset = statusBarHeight + navigationBarHeight;
    
    // 创建并配置你的视图
    self.cityTextField = [[UITextField alloc] initWithFrame:CGRectMake(10, topOffset, 100, 60)];
    self.cityTextField.delegate = self;
    self.cityTextField.placeholder = @"城市名称";
    self.cityTextField.text = @"";
    // 添加视图到主视图
    [self.view addSubview:self.cityTextField];
    
    // 创建并配置你的视图
    self.textField = [[UITextField alloc] initWithFrame:CGRectMake(129, topOffset, self.view.bounds.size.width-200, 60)];
    self.textField.delegate = self;
    self.textField.placeholder = @"请输入地址";
    // 添加视图到主视图
    [self.view addSubview:self.textField];
    
    self.searchBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.searchBtn setTitle:@"搜索" forState:UIControlStateNormal];
    [self.searchBtn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    [self.searchBtn addTarget:self action:@selector(beginSearch) forControlEvents:UIControlEventTouchUpInside];
    self.searchBtn.frame = CGRectMake(CGRectGetMaxX(self.textField.frame), topOffset, 60, 60);
    
    [self.view addSubview:self.searchBtn];
    
    // 初始化数据
    self.cellDataArray = [NSMutableArray array];
    
    // 创建并设置TableView
    self.tableView = [[UITableView alloc] initWithFrame:CGRectMake(0, CGRectGetMaxY(self.textField.frame), self.view.bounds.size.width, self.view.bounds.size.height - CGRectGetMaxY(self.textField.frame)) style:UITableViewStylePlain];
    self.tableView.dataSource = self;
    self.tableView.delegate = self;
    self.tableView.tableFooterView = [UIView new];
    [self.tableView registerClass:[SearchPoiListCell class] forCellReuseIdentifier:@"CommonSelectTableViewCell"];
    
    [self.view addSubview:self.tableView];
    
    self.search = [[BMKSuggestionSearch alloc] init];
    self.search.delegate = self;
}

- (void)beginSearch {
    [self.textField endEditing:YES];
    BMKSuggestionSearchOption* option = [[BMKSuggestionSearchOption alloc] init];
    option.cityname  = self.cityTextField.text;
    option.keyword  = self.textField.text;
    option.cityLimit = YES;
    BOOL flag = [self.search suggestionSearch:option];
    if (flag) {
        NSLog(@"Sug检索发送成功");
    }  else  {
        NSLog(@"Sug检索发送失败");
    }
}
/**
 *返回suggestion搜索结果
 *@param searcher 搜索对象
 *@param result 搜索结果
 *@param error 错误号，@see BMKSearchErrorCode
 */
- (void)onGetSuggestionResult:(BMKSuggestionSearch*)searcher result:( BMKSuggestionSearchResult*)result errorCode:(BMKSearchErrorCode)error{
    if (error == BMK_SEARCH_NO_ERROR) {
        [self.cellDataArray removeAllObjects];
        //在此处理正常结果
        for (int i = 0; i< result.suggestionList.count; i++) {
            BMKSuggestionInfo *info = result.suggestionList[i];
            BNRoutePlanNode *node = [[BNRoutePlanNode alloc] init];
            node.title = info.key;
            node.uid = info.uid;
            node.cityID = info.city;
            node.pos = [[BNPosition alloc] init];
            node.pos.x = info.location.longitude;
            node.pos.y = info.location.latitude;
            node.pos.eType = BNCoordinate_BaiduMapSDK;
            SearchPoiListCellModel *data = [[SearchPoiListCellModel alloc] initWithTitle:@"" node:node];
            [self.cellDataArray addObject:data];
        }
        [self.tableView reloadData];
    }  else {
        NSLog(@"检索失败");
    }
}

#pragma mark - UITableViewDataSource

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.cellDataArray.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    SearchPoiListCell *cell = [tableView dequeueReusableCellWithIdentifier:@"CommonSelectTableViewCell" forIndexPath:indexPath];
    
    SearchPoiListCellModel *data = self.cellDataArray[indexPath.row];
    [cell configureWithCellData:data];
    
    return cell;
}


#pragma mark - UITableViewDelegate

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    return 80.0; // 设置每个cell的高度
}

-(void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    if (self.delegate && [self.delegate respondsToSelector:@selector(didSelectPoi:type:)]) {
        [self.delegate didSelectPoi:self.cellDataArray[indexPath.row] type:self.type];
    }
    [self.navigationController popViewControllerAnimated:YES];
}

@end
