//
//  SearchPoiListCell.m
//  NaviDemo
//
//  Created by v_lisisi on 2024/6/26.
//  Copyright © 2024 v_qinruiguang. All rights reserved.
//

#import "SearchPoiListCell.h"
@interface SearchPoiListCell ()

@property (nonatomic, strong) UILabel *titleLabel;
@property (nonatomic, strong) UILabel *xLabel;
@property (nonatomic, strong) UILabel *yLabel;

@end

@implementation SearchPoiListCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier {
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self setupViews];
    }
    return self;
}

- (void)setupViews {
    self.titleLabel = [[UILabel alloc] initWithFrame:CGRectMake(15, 10, self.frame.size.width-30, 20)];
    [self.contentView addSubview:self.titleLabel];
    
    self.xLabel = [[UILabel alloc] initWithFrame:CGRectMake(15, 40, self.frame.size.width/2-25, 20)];
    [self.contentView addSubview:self.xLabel];
    
    self.yLabel = [[UILabel alloc] initWithFrame:CGRectMake(CGRectGetMaxX(self.xLabel.frame)+5, 40, self.frame.size.width/2-25, 20)];
    [self.contentView addSubview:self.yLabel];
}

- (void)configureWithCellData:(SearchPoiListCellModel *)data {
    self.titleLabel.text = data.node.title;
    self.xLabel.text = [NSString stringWithFormat:@"x: %.8f", data.node.pos.x];
    self.yLabel.text = [NSString stringWithFormat:@"y: %.8f", data.node.pos.y];
}

@end
