//
//  RoutePlanViewController.m
//  NaviDemo
//
//  Created by v_lisisi on 2024/6/26.
//  Copyright © 2024 v_qinruiguang. All rights reserved.
//

#import "RoutePlanViewController.h"
#import "NaviTypeSegmentView.h"
#import "SearchPoiListCellModel.h"
#import "RoutePlanNodeView.h"
#import "SearchPoiListViewController.h"
#import "BNaviService.h"
#import "CustomNaviBaseViewController.h"

#import "RoutePlanPreferenceView.h"
#import "BNRoutePreferenceSelectView.h"
#import "CustomChooseTimeView.h"
#import "BNNaviElderlyRoutePreferenceModel.h"
#import "BNDatePickerViewController.h"
#import "NSDate+BNFutureTrip.h"
#import "CommonLoadingView.h"
#import "RoutePlanTableViewCell.h"
@interface RoutePlanViewController ()<NaviTypeSegmentViewDelegate, SelectSearchPOiDelegate, BNNaviRoutePlanDelegate, BNDatePickerViewControllerDelegate, UITableViewDelegate, UITableViewDataSource>
@property (nonatomic, strong) NaviTypeSegmentView *naviTypeView;

@property (nonatomic, strong) RoutePlanNodeView *startDataView;
@property (nonatomic, strong) RoutePlanNodeView *endDataView;
@property (nonatomic, strong) SearchPoiListCellModel *startData;
@property (nonatomic, strong) SearchPoiListCellModel *endData;
@property (nonatomic, strong) UIButton *routePlanBtn;
@property (nonatomic, strong) NSDate *selectDate; //未来出行 开始时间
@property (nonatomic, strong) RoutePlanPreferenceView *preferenceView;

@property (nonatomic, strong) CustomChooseTimeView *chooesView;

@property (nonatomic, strong) BNRoutePreferenceSelectView *prefernceSelectView;
@property(nonatomic, assign) BNRoutePlanMode preferenceType;
@property (nonatomic, strong) CommonLoadingView *loadingView;

@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) NSMutableArray *data;
@end

@implementation RoutePlanViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self creatView];
}

#pragma mark --CreatView
- (void)creatView {
    self.title = @"选择导航类型起终点";
    self.view.backgroundColor = [UIColor whiteColor];
    [self creatNaviTypView];
    [self creatPrefernceView];
    [self creatStartView];
    [self creatEndView];
    [self creatRoutePlanView];
    [self creatTableView];
    
}
- (void)creatNaviTypView {
    // 获取状态栏和导航栏的总高度
    CGFloat statusBarHeight = [UIApplication sharedApplication].statusBarFrame.size.height;
    CGFloat navigationBarHeight = self.navigationController.navigationBar.frame.size.height;
    CGFloat topOffset = statusBarHeight + navigationBarHeight;
    
    NSArray *buttonInfos = [self getNaviTypeSegmentModelArray];
    // 创建 CustomButtonView
    self.naviTypeView = [[NaviTypeSegmentView alloc] initWithFrame:CGRectMake(20, topOffset+20, self.view.bounds.size.width - 40, 50) buttonInfos:buttonInfos];
    self.naviTypeView.delegate = self;
    self.naviTypeView.naviType = self.naviType;
    // 添加到主视图
    [self.view addSubview:self.naviTypeView];
}

- (void)creatStartView {
    if (self.isFuture) {
        self.chooesView = [[CustomChooseTimeView alloc] initWithFrame:CGRectMake(20, CGRectGetMaxY(self.preferenceView.frame), self.view.bounds.size.width - 40, 40)];
        self.chooesView.leftLabel.text = @"未来出行:";
        [self.chooesView.timeBtn addTarget:self action:@selector(tapTimeBtn:) forControlEvents:UIControlEventTouchUpInside];
        [self.view addSubview:self.chooesView];
        // 创建并配置 CustomView
        self.startDataView = [[RoutePlanNodeView alloc] initWithFrame:CGRectMake(0, CGRectGetMaxY(self.chooesView.frame), self.view.bounds.size.width, 60)];
        self.selectDate = [NSDate date];
    } else {
        // 创建并配置 CustomView
        self.startDataView = [[RoutePlanNodeView alloc] initWithFrame:CGRectMake(0, CGRectGetMaxY(self.preferenceView.frame), self.view.bounds.size.width, 60)];
    }
    CLLocation *myLocation = [BNaviService_Location getLastLocation];
    BNRoutePlanNode *startNode = [[BNRoutePlanNode alloc] init];
    startNode.pos = [[BNPosition alloc] init];
    startNode.pos.x = myLocation.coordinate.longitude;
    startNode.pos.y = myLocation.coordinate.latitude;
    startNode.pos.eType = BNCoordinate_OriginalGPS;
    startNode.title = @"我的位置";
    self.startData = [[SearchPoiListCellModel alloc] initWithTitle:@"起点" node:startNode];
    self.startDataView.actionButton.tag = 0;
    [self.startDataView.actionButton addTarget:self action:@selector(updateNodeAction:) forControlEvents:UIControlEventTouchUpInside];
    // 添加到主视图
    [self.view addSubview:self.startDataView];
    
}

- (void)creatEndView {
    BNRoutePlanNode *endNode = [[BNRoutePlanNode alloc] init];
    endNode.pos = [[BNPosition alloc] init];
    endNode.pos.x = 113.940868;
    endNode.pos.y = 22.54647;
    endNode.pos.eType = BNCoordinate_BaiduMapSDK;
    endNode.title = @"腾讯大厦";
    // 创建并配置 CustomView
    self.endDataView = [[RoutePlanNodeView alloc] initWithFrame:CGRectMake(0, CGRectGetMaxY(self.startDataView.frame), self.view.bounds.size.width, 60)];
    self.endData = [[SearchPoiListCellModel alloc] initWithTitle:@"终点" node:endNode];
    self.endDataView.actionButton.tag = 1;
    [self.endDataView.actionButton addTarget:self action:@selector(updateNodeAction:) forControlEvents:UIControlEventTouchUpInside];
    // 添加到主视图
    [self.view addSubview:self.endDataView];
}

-(void)creatRoutePlanView {
    self.routePlanBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.routePlanBtn setTitle:@"开始算路" forState:UIControlStateNormal];
    // 设置按钮风格
    self.routePlanBtn.layer.cornerRadius = 8.0;
    self.routePlanBtn.backgroundColor = [UIColor systemBlueColor];
    [self.view addSubview:self.routePlanBtn];
    self.routePlanBtn.frame = CGRectMake(30, self.view.frame.size.height - 60, self.view.frame.size.width - 60, 40);
    [self.routePlanBtn addTarget:self action:@selector(tapRoutePlane) forControlEvents:UIControlEventTouchUpInside];
    
}

-(void)creatTableView {
    self.data = [[NSMutableArray alloc] init];
    self.tableView = [[UITableView alloc] initWithFrame:CGRectMake(0, CGRectGetMaxY(self.endDataView.frame), self.view.frame.size.width, self.view.frame.size.height - CGRectGetMaxY(self.endDataView.frame) - 70) style:UITableViewStyleGrouped];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    [self.view addSubview:self.tableView];
    [self.tableView registerClass:[RoutePlanTableViewCell class] forCellReuseIdentifier:@"RoutePlanTableViewCell"];
    self.tableView.tableFooterView = [UIView new];
    self.tableView.rowHeight = 70;
    [self setupTableHeaderView];
}

// 设置 tableHeaderView
- (void)setupTableHeaderView {
    UIView *headerView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, self.view.frame.size.width, 50)];
    headerView.backgroundColor = [UIColor whiteColor];
    
    UIButton *addButton = [UIButton buttonWithType:UIButtonTypeSystem];
    [addButton setTitle:@"添加途径点" forState:UIControlStateNormal];
    addButton.titleLabel.font = [UIFont boldSystemFontOfSize:18];
    addButton.frame = CGRectMake(0, 0, 150, 40);
    addButton.center = headerView.center;
    [addButton addTarget:self action:@selector(addNodeButtonTapped) forControlEvents:UIControlEventTouchUpInside];
    
    [headerView addSubview:addButton];
    self.tableView.tableHeaderView = headerView;
}

- (void)creatPrefernceView {
    self.preferenceView = [[RoutePlanPreferenceView alloc] initWithFrame:CGRectMake(20, CGRectGetMaxY(self.naviTypeView.frame)+10, self.view.bounds.size.width -40, 40)];
    self.preferenceType = BNRoutePlanMode_Recommend;
    [self.preferenceView.actionButton addTarget:self action:@selector(buttonTapped:) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:self.preferenceView];
}

- (void)addNodeButtonTapped {
    SearchPoiListViewController *vc = [[SearchPoiListViewController alloc] init];
    vc.delegate = self;
    vc.type = -1;
    [self.navigationController pushViewController:vc animated:YES];
}
#pragma  mark -- tableViewDelegate
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.data.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    RoutePlanTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"RoutePlanTableViewCell" forIndexPath:indexPath];
    cell.nodeView.data = self.data[indexPath.row];
    cell.nodeView.actionButton.tag = indexPath.row + 2;
    [cell.nodeView.actionButton addTarget:self action:@selector(updateNodeAction:) forControlEvents:UIControlEventTouchUpInside];
    return cell;
}

- (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath {
    return YES;
}

// 提交编辑操作
- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath {
    if (editingStyle == UITableViewCellEditingStyleDelete) {
        // 删除数据源中的元素
        [self.data removeObjectAtIndex:indexPath.row];
        // 删除对应的行
        [tableView deleteRowsAtIndexPaths:@[indexPath] withRowAnimation:UITableViewRowAnimationAutomatic];
    }
}
// 自定义删除按钮的文字（可选）
- (NSString *)tableView:(UITableView *)tableView titleForDeleteConfirmationButtonForRowAtIndexPath:(NSIndexPath *)indexPath {
    return @"删除";
}

#pragma mark --Func

-(void)updateNodeAction:(UIButton *)sender {
    SearchPoiListViewController *vc = [[SearchPoiListViewController alloc] init];
    vc.delegate = self;
    vc.type = sender.tag;
    [self.navigationController pushViewController:vc animated:YES];
}

- (void)showLoading {
    if (!self.loadingView) {
        self.loadingView = [[CommonLoadingView alloc] initWithFrame:self.view.bounds];
        [self.view addSubview:self.loadingView];
    }
    
    [self.loadingView setMessage:@"Loading..."];
}

- (void)hideLoading {
    [self.loadingView stopLoading];
    self.loadingView = nil;
}

- (void)buttonTapped:(UIButton *)sender {
    [self.prefernceSelectView show];
}

-(BNRoutePreferenceSelectView *)prefernceSelectView {
    if (!_prefernceSelectView) {
        _prefernceSelectView = [[BNRoutePreferenceSelectView alloc] initWithFrame:CGRectMake(0, 0, self.view.bounds.size.width, self.view.bounds.size.height)];
        [_prefernceSelectView hid];
        __weak typeof(self) weakSelf = self;
        _prefernceSelectView.block = ^(NSDictionary *dict) {
            if (dict) {
                BNNaviElderlyRoutePreferenceModel *selectMode = dict[@"Data"];
                [weakSelf.preferenceView.actionButton setTitle:selectMode.preferenceStr forState:UIControlStateNormal];
                weakSelf.preferenceType = selectMode.preferenceType;
            }
            
        };
        [self.view addSubview:_prefernceSelectView];
    }
    return  _prefernceSelectView;
}
- (void)tapTimeBtn:(UIButton *)sender {
    BNDatePickerViewController * datePicker = [[BNDatePickerViewController alloc] init];
    datePicker.delegate = self;
    datePicker.modalPresentationStyle = UIModalPresentationOverFullScreen;
    
    NSDate * selectedDate = self.selectDate;
    datePicker.initialSelectedDateAligned = selectedDate;
    
    [self presentViewController:datePicker animated:NO completion:^{
        
    }];
    
}

-(void)tapRoutePlane {
    if (!self.endData.node) {
        return;
    }
    
    [self showLoading];
    NSMutableArray *nodes = [NSMutableArray array];
    [nodes addObject:self.startData.node];
    for (int i = 0; i<self.data.count; i++) {
        SearchPoiListCellModel *model = self.data[i];
        if (model.node) {
            [nodes addObject:model.node];
        }
    }
    
    [nodes addObject:self.endData.node];
    
    if (self.selectDate) {
        BNTripManagerTimeModel *beginTimeModel = [[BNTripManagerTimeModel alloc] init];
        beginTimeModel.nYear = self.selectDate.year;
        beginTimeModel.nMonth = self.selectDate.month;
        beginTimeModel.nDay = self.selectDate.day;
        beginTimeModel.nHour = self.selectDate.hour;
        beginTimeModel.nMinute = self.selectDate.minute;
        [BNaviService_RoutePlan startNaviRoutePlan:self.preferenceType naviNodes:nodes time:nil delegete:self userInfo:@{BNaviTripeBeginTimeKey: beginTimeModel, BNaviTripTypeKey: @(self.naviType)}];
    } else {
        [BNaviService_RoutePlan startNaviRoutePlan:self.preferenceType naviNodes:nodes time:nil delegete:self userInfo:@{BNaviTripTypeKey: @(self.naviType)}];
    }
    
}

#pragma mark -- BNNaviRoutePlanDelegate
-(void)routePlanDidFinished:(NSDictionary *)userInfo {
    [self hideLoading];
    if (self.block) {
        self.block(YES, self.naviType);
    }
}

-(void)routePlanDidFailedWithError:(NSError *)error andUserInfo:(NSDictionary *)userInfo {
    [self hideLoading];
    if (self.block) {
        self.block(NO, self.naviType);
    }
}

#pragma mark -- NaviTypeSegmentViewDelegate
- (void)buttonView:(UIView *)buttonView didSelectButtonWithType:(BN_NaviType)type {
    self.naviType = type;
}

#pragma mark -- SelectSearchPOiDelegate
- (void)didSelectPoi:(SearchPoiListCellModel *)data type:(NSInteger)type {
    if (type == 0) {
        self.startData = data;
    } else if (type == 1) {
        self.endData =  data;
    } else if (type == -1) {
        data.title = [NSString stringWithFormat:@"途径点%ld", self.data.count+1];
        [self.data addObject:data];
        [self.tableView reloadData];
    } else {
        if (self.data.count > (type - 2)) {
            data.title = [NSString stringWithFormat:@"途径点%ld", (type-1)];
            self.data[(type - 2)] = data;
        }
        [self.tableView reloadData];
    }
}



#pragma mark -- BNDatePickerViewControllerDelegate
- (void)datePickerDidOK:(BNDatePickerViewController*)picker {
    NSLog(@"%@", picker.selectedDate);
    self.selectDate = picker.selectedDate;
}

- (void)setSelectDate:(NSDate *)selectDate {
    _selectDate = selectDate;
    [self.chooesView.timeBtn setTitle:[NSString stringWithFormat:@"%ld-%ld-%ld-%ld-%ld", selectDate.year, selectDate.month, selectDate.day, selectDate.hour, selectDate.minute] forState:UIControlStateNormal];
    
}
#pragma mark --Data
-(void)setStartData:(SearchPoiListCellModel *)startData {
    _startData = startData;
    _startData.title = @"起点";
    self.startDataView.data = startData;
}

-(void)setEndData:(SearchPoiListCellModel *)endData {
    _endData = endData;
    _endData.title = @"终点";
    self.endDataView.data = endData;
}

- (NSArray *)getNaviTypeSegmentModelArray {
    if (self.isCustomUI) {
        return  @[
            [[NaviTypeSegmentModel alloc] initWithTitle:@"驾车" type:BN_NaviTypeReal],
            [[NaviTypeSegmentModel alloc] initWithTitle:@"货车" type:BN_NaviTypeTruck],
            [[NaviTypeSegmentModel alloc] initWithTitle:@"摩托车" type:BN_NaviTypeMoto]
        ];
    }
    if (self.naviType == BN_NaviTypeReal) {
        return  @[
            [[NaviTypeSegmentModel alloc] initWithTitle:@"驾车" type:BN_NaviTypeReal]
        ];
    } else if (self.naviType == BN_NaviTypeTruck) {
        return  @[
            [[NaviTypeSegmentModel alloc] initWithTitle:@"货车" type:BN_NaviTypeTruck]
        ];
    } else if (self.naviType == BN_NaviTypeMoto) {
        return @[
            [[NaviTypeSegmentModel alloc] initWithTitle:@"摩托车" type:BN_NaviTypeMoto]
        ];
    } else {
        return  @[
            [[NaviTypeSegmentModel alloc] initWithTitle:@"驾车" type:BN_NaviTypeReal],
            [[NaviTypeSegmentModel alloc] initWithTitle:@"货车" type:BN_NaviTypeTruck],
            [[NaviTypeSegmentModel alloc] initWithTitle:@"摩托车" type:BN_NaviTypeMoto]
        ];
    }
}
@end
