//
//  RoutePlanPreferenceView.m
//  NaviDemo
//
//  Created by v_lisisi on 2024/7/4.
//  Copyright © 2024 v_qinruiguang. All rights reserved.
//

#import "RoutePlanPreferenceView.h"

@implementation RoutePlanPreferenceView

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        [self setupViews];
        [self setupConstraints];
    }
    return self;
}

- (void)setupViews {
    // 初始化并配置 titleLabel
    self.titleLabel = [[UILabel alloc] init];
    self.titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
    self.titleLabel.text = @"算路偏好:";
    self.titleLabel.textAlignment = NSTextAlignmentLeft;
    [self addSubview:self.titleLabel];

    // 初始化并配置 actionButton
    self.actionButton = [UIButton buttonWithType:UIButtonTypeSystem];
    self.actionButton.translatesAutoresizingMaskIntoConstraints = NO;
    [self.actionButton setTitle:@"智能推荐" forState:UIControlStateNormal];
    [self addSubview:self.actionButton];
}

- (void)setupConstraints {
    // 设置 titleLabel 的约束，宽度为固定值
       CGFloat titleLabelWidth = 100.0; // 例如，固定宽度为100
       [NSLayoutConstraint activateConstraints:@[
           [self.titleLabel.leadingAnchor constraintEqualToAnchor:self.leadingAnchor constant:8],
           [self.titleLabel.centerYAnchor constraintEqualToAnchor:self.centerYAnchor],
           [self.titleLabel.widthAnchor constraintEqualToConstant:titleLabelWidth]
       ]];
       
       // 设置 actionButton 的约束
       [NSLayoutConstraint activateConstraints:@[
           [self.actionButton.leadingAnchor constraintEqualToAnchor:self.titleLabel.trailingAnchor constant:8],
           [self.actionButton.trailingAnchor constraintEqualToAnchor:self.trailingAnchor constant:-8],
           [self.actionButton.centerYAnchor constraintEqualToAnchor:self.centerYAnchor]
       ]];
}



@end
