//
//  RoutePlanNodeView.m
//  NaviDemo
//
//  Created by v_lisisi on 2024/6/27.
//  Copyright © 2024 v_qinruiguang. All rights reserved.
//

#import "RoutePlanNodeView.h"

@interface RoutePlanNodeView ()
@property (nonatomic, strong) UILabel *titleLabel;
@property (nonatomic, strong) UILabel *nameLabel;
@property (nonatomic, strong) UILabel *xLabel;
@property (nonatomic, strong) UILabel *yLabel;

@end

@implementation RoutePlanNodeView

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        [self setupViews];
        [self setupConstraints];
    }
    return self;
}

- (void)setupViews {
    // 初始化子视图
    self.titleLabel = [[UILabel alloc] init];
    self.titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
    self.titleLabel.text = @"Title";
    [self addSubview:self.titleLabel];
    
    self.nameLabel = [[UILabel alloc] init];
    self.nameLabel.translatesAutoresizingMaskIntoConstraints = NO;
    self.nameLabel.text = @"Name";
    [self addSubview:self.nameLabel];
    
    self.xLabel = [[UILabel alloc] init];
    self.xLabel.translatesAutoresizingMaskIntoConstraints = NO;
    self.xLabel.text = @"X";
    [self addSubview:self.xLabel];
    
    self.yLabel = [[UILabel alloc] init];
    self.yLabel.translatesAutoresizingMaskIntoConstraints = NO;
    self.yLabel.text = @"Y";
    [self addSubview:self.yLabel];
    
    self.actionButton = [UIButton buttonWithType:UIButtonTypeSystem];
    self.actionButton.translatesAutoresizingMaskIntoConstraints = NO;
    [self.actionButton setTitle:@"搜索POI" forState:UIControlStateNormal];
    [self addSubview:self.actionButton];
}

- (void)setupConstraints {
    // 设置 Auto Layout 约束
    
    // titleLabel 约束
    [NSLayoutConstraint activateConstraints:@[
        [self.titleLabel.leadingAnchor constraintEqualToAnchor:self.leadingAnchor constant:10],
        [self.titleLabel.centerYAnchor constraintEqualToAnchor:self.centerYAnchor],
        [self.titleLabel.widthAnchor constraintEqualToConstant:80]
    ]];
    
    // nameLabel 约束
    [NSLayoutConstraint activateConstraints:@[
        [self.nameLabel.leadingAnchor constraintEqualToAnchor:self.titleLabel.trailingAnchor constant:10],
        [self.nameLabel.topAnchor constraintEqualToAnchor:self.topAnchor constant:10],
        [self.nameLabel.trailingAnchor constraintEqualToAnchor:self.actionButton.leadingAnchor constant:-10]
    ]];
    
    // xLabel 约束
    [NSLayoutConstraint activateConstraints:@[
        [self.xLabel.leadingAnchor constraintEqualToAnchor:self.nameLabel.leadingAnchor],
        [self.xLabel.topAnchor constraintEqualToAnchor:self.nameLabel.bottomAnchor constant:10],
        [self.xLabel.widthAnchor constraintEqualToAnchor:self.yLabel.widthAnchor]
    ]];
    
    // yLabel 约束
    [NSLayoutConstraint activateConstraints:@[
        [self.yLabel.leadingAnchor constraintEqualToAnchor:self.xLabel.trailingAnchor constant:10],
        [self.yLabel.topAnchor constraintEqualToAnchor:self.xLabel.topAnchor],
        [self.yLabel.trailingAnchor constraintEqualToAnchor:self.actionButton.leadingAnchor constant:-10],
        [self.yLabel.widthAnchor constraintEqualToAnchor:self.xLabel.widthAnchor]
    ]];
    
    // actionButton 约束
    [NSLayoutConstraint activateConstraints:@[
        [self.actionButton.trailingAnchor constraintEqualToAnchor:self.trailingAnchor constant:-10],
        [self.actionButton.centerYAnchor constraintEqualToAnchor:self.centerYAnchor],
        [self.actionButton.widthAnchor constraintEqualToConstant:60]
    ]];
}

-(void)setData:(SearchPoiListCellModel *)data {
    _data =data;
    self.titleLabel.text = data.title;
    self.nameLabel.text = data.node.title;
    self.xLabel.text = [NSString stringWithFormat:@"%f", data.node.pos.x];
    self.yLabel.text = [NSString stringWithFormat:@"%f", data.node.pos.y];
}

@end
