//
//  NaviTypeSegmentView.m
//  NaviDemo
//
//  Created by v_lisisi on 2024/6/26.
//  Copyright © 2024 v_qinruiguang. All rights reserved.
//

#import "NaviTypeSegmentView.h"



@interface NaviTypeSegmentView ()

@property (nonatomic, strong) NSMutableArray<UIButton *> *buttons;
@property (nonatomic, assign) CGFloat buttonSpacing;
@property (nonatomic, strong) NSArray<NaviTypeSegmentModel *> *buttonInfos;

@end


@implementation NaviTypeSegmentView

- (instancetype)initWithFrame:(CGRect)frame buttonInfos:(NSArray<NaviTypeSegmentModel *> *)buttonInfos {
    self = [super initWithFrame:frame];
    if (self) {
        self.buttonSpacing = 10.0; // 设置按钮之间的间隙
        self.buttonInfos = buttonInfos;
        [self setupButtonsWithInfos:buttonInfos];
    }
    return self;
}

- (void)setupButtonsWithInfos:(NSArray<NaviTypeSegmentModel *> *)infos {
    NSUInteger buttonCount = infos.count;

    self.buttons = [NSMutableArray array];
    
    for (NSUInteger i = 0; i < buttonCount; i++) {
        UIButton *button = [UIButton buttonWithType:UIButtonTypeSystem];
        [button setTitle:infos[i].title forState:UIControlStateNormal];
        button.tag = infos[i].type;
        [button addTarget:self action:@selector(buttonTapped:) forControlEvents:UIControlEventTouchUpInside];
        
        // 设置按钮风格
        button.layer.cornerRadius = 8.0;
        button.layer.borderWidth = 1.0;
        button.layer.borderColor = [UIColor systemBlueColor].CGColor;
        button.backgroundColor = [UIColor whiteColor];
        [button setTitleColor:[UIColor systemBlueColor] forState:UIControlStateNormal];
        
        [self.buttons addObject:button];
        [self addSubview:button];
        if (i == 0) {
            [self buttonTapped:button];
        }
    }
    
}

- (void)layoutSubviews {
    [super layoutSubviews];
    
    NSUInteger buttonCount = self.buttons.count;
    CGFloat totalSpacing = self.buttonSpacing * (buttonCount - 1);
    CGFloat buttonWidth = (self.bounds.size.width - totalSpacing) / buttonCount;
    CGFloat buttonHeight = self.bounds.size.height;
    
    for (NSUInteger i = 0; i < buttonCount; i++) {
        UIButton *button = self.buttons[i];
        CGFloat xPosition = i * (buttonWidth + self.buttonSpacing);
        button.frame = CGRectMake(xPosition, 0, buttonWidth, buttonHeight);
    }
}

- (void)buttonTapped:(UIButton *)sender {
    for (UIButton *button in self.buttons) {
        button.selected = NO;
        button.backgroundColor = [UIColor whiteColor];
        [button setTitleColor:[UIColor systemBlueColor] forState:UIControlStateNormal];
        button.layer.borderColor = [UIColor systemBlueColor].CGColor;
    }
    
    sender.selected = YES;
    sender.backgroundColor = [UIColor systemBlueColor];
    [sender setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    sender.layer.borderColor = [UIColor systemBlueColor].CGColor;
    
    if ([self.delegate respondsToSelector:@selector(buttonView:didSelectButtonWithType:)]) {
        [self.delegate buttonView:self didSelectButtonWithType:(BN_NaviType)sender.tag];
    }
}
- (void)setNaviType:(BN_NaviType)naviType {
    _naviType = naviType;
    for (UIButton *button in self.buttons) {
        if (button.tag == naviType) {
            [self buttonTapped:button];
        }
    }
    
}
@end
