//
//  NaviTypeSegmentView.h
//  NaviDemo
//
//  Created by v_lisisi on 2024/6/26.
//  Copyright © 2024 v_qinruiguang. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "BNCommonDef.h"
#import "NaviTypeSegmentModel.h"
NS_ASSUME_NONNULL_BEGIN

@protocol NaviTypeSegmentViewDelegate <NSObject>
- (void)buttonView:(UIView *)buttonView didSelectButtonWithType:(BN_NaviType)type;
@end


@interface NaviTypeSegmentView : UIView

@property (nonatomic, weak) id<NaviTypeSegmentViewDelegate> delegate;
@property (nonatomic, assign) BN_NaviType  naviType;
- (instancetype)initWithFrame:(CGRect)frame buttonInfos:(NSArray<NaviTypeSegmentModel *> *)buttonInfos;


@end

NS_ASSUME_NONNULL_END
