//
//  CustomChooseTimeView.m
//  NaviDemo
//
//  Created by v_lisisi on 2024/7/9.
//  Copyright © 2024 v_qinruiguang. All rights reserved.
//

#import "CustomChooseTimeView.h"

@implementation CustomChooseTimeView


- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        [self setupViews];
    }
    return self;
}

- (void)setupViews {
    self.leftLabel = [[UILabel alloc] init];
    [self addSubview:self.leftLabel];
    
    self.timeBtn = [UIButton buttonWithType:UIButtonTypeSystem];
    [self.timeBtn setTitle:@"时间" forState:UIControlStateNormal];
    self.timeBtn.backgroundColor = [UIColor whiteColor];
    [self.timeBtn setTitleColor:[UIColor systemBlueColor] forState:UIControlStateNormal];
    [self addSubview:self.timeBtn];
    
    self.leftLabel.frame = CGRectMake(0, (self.bounds.size.height - 20 )/2, 80, 20);
    self.timeBtn.frame = CGRectMake(CGRectGetMaxX(self.leftLabel.frame)+20, (self.bounds.size.height - 40)/2, 200, 40);
}


@end
