//
//  CommonLoadingView.m
//  NaviDemo
//
//  Created by v_lisisi on 2024/11/26.
//  Copyright © 2024 v_qinruiguang. All rights reserved.
//

#import "CommonLoadingView.h"

@interface CommonLoadingView ()
@property (nonatomic, strong) UIActivityIndicatorView *spinner;
@property (nonatomic, strong) UILabel *messageLabel;
@end

@implementation CommonLoadingView


- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        // 设置背景（半透明效果）
        self.backgroundColor = [[UIColor blackColor] colorWithAlphaComponent:0.5];
        
        // 初始化加载指示器
        if (@available(iOS 13.0, *)) {
            self.spinner = [[UIActivityIndicatorView alloc] initWithActivityIndicatorStyle:UIActivityIndicatorViewStyleLarge];
        } else {
            self.spinner = [[UIActivityIndicatorView alloc] initWithActivityIndicatorStyle:UIActivityIndicatorViewStyleWhiteLarge];
        }
        self.spinner.color = [UIColor whiteColor];
        self.spinner.hidesWhenStopped = YES;
        self.spinner.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:self.spinner];
        
        // 初始化文案标签
        self.messageLabel = [[UILabel alloc] init];
        self.messageLabel.textColor = [UIColor whiteColor];
        self.messageLabel.font = [UIFont systemFontOfSize:16];
        self.messageLabel.textAlignment = NSTextAlignmentCenter;
        self.messageLabel.numberOfLines = 0; // 支持多行
        self.messageLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:self.messageLabel];
        
        // 添加约束
        [NSLayoutConstraint activateConstraints:@[
            [self.spinner.centerXAnchor constraintEqualToAnchor:self.centerXAnchor],
            [self.spinner.centerYAnchor constraintEqualToAnchor:self.centerYAnchor constant:-20],
            
            [self.messageLabel.topAnchor constraintEqualToAnchor:self.spinner.bottomAnchor constant:10],
            [self.messageLabel.leadingAnchor constraintEqualToAnchor:self.leadingAnchor constant:20],
            [self.messageLabel.trailingAnchor constraintEqualToAnchor:self.trailingAnchor constant:-20]
        ]];
        
        // 启动加载动画
        [self.spinner startAnimating];
    }
    return self;
}

- (void)setMessage:(NSString *)message {
    self.messageLabel.text = message;
}

- (void)stopLoading {
    [self.spinner stopAnimating];
    [self removeFromSuperview];
}


@end
