//
//  BNUIManagerProtocol.h
//  baiduNaviSDK
//
//  Created by Baidu on 11/10/13.
//  Copyright (c) 2013 baidu. All rights reserved.
//

#ifndef baiduNaviSDK_BNUIManagerProtocol_h
#define baiduNaviSDK_BNUIManagerProtocol_h

#import "BNCommonDef.h"

extern NSString* BNaviUI_NormalNavi_TypeKey;

extern NSString* BNaviUI_Navi_HideDeclarationKey;

typedef enum _BNaviUIType{
    BNaviUI_Unknown = 0,
    BNaviUI_NormalNavi,         //正常导航
    BNaviUI_Declaration = 11,       //声明页面
}BNaviUIType;

/**
 退出UI的两种方式
 EN_BNavi_ExitTopVC：
 退出最顶层的ViewController，如果退出后已经是最底部的controller，退出整个导航组件
 EN_BNavi_ExitAllVC：
 退出整个导航组件
 */
typedef enum _BNavi_ExitPage_Type {
    
    EN_BNavi_ExitTopVC,
    EN_BNavi_ExitAllVC
    
}BNavi_ExitPage_Type;

@protocol BNNaviUIManagerDelegate;


/// UI管理接口
@protocol BNUIManagerProtocol

@required

/**
 *  获取当前NavigationController
 */
- (id)navigationController;

/**
 *  展示导航页面
 *  默认开始真实导航，要开始模拟导航，需要在额外参数传入{BNaviUI_NormalNavi_TypeKey: @(BN_NaviTypeSimulator)}
 *  @param pageType BNaviUIType类型
 *  @param delegate BNNaviUIManagerDelegate代理
 *  @param extParams 额外参数
 *  额外参数BNaviUI_NormalNavi_TypeKey：1.真实导航:BN_NaviTypeReal，2.模拟导航:BN_NaviTypeSimulator，3.货车导航:BN_NaviTypeTruck，4.货车模拟导航:BN_NaviTypeTruckSimulator
 *  BNaviUI_Navi_HideDeclarationKey :@(YES) 可隐藏首次进入导航的免责声明。默认为@(NO) 首次会展示免责声明。
 */
- (void)showPage:(BNaviUIType)pageType
        delegate:(id<BNNaviUIManagerDelegate>)delegate
       extParams:(NSDictionary*)extParams;

/**
 *  退出导航页面
 *  注意，如果shouldOverrideExitingPage返回YES，调用exitPage方法不会退出导航，而是调用用户自定义的overrideExitingPage
 *  @param exitType BNavi_ExitPage_Type类型
 *  @param animated 是否需要动画
 *  @param extraInfo 额外参数
 */
- (void)exitPage:(BNavi_ExitPage_Type)exitType animated:(BOOL)animated extraInfo:(NSDictionary *)extraInfo;

/// 退出专业导航
/// ⚠️在轻导航中通过 [BNaviService_LightNavi switchToRealNav:self withNaviType:self.naviType ]进入专业导航。若需退出专业导航，开发者应主动调用此接口。
/// @param extraInfo 额外参数
- (void)exitNaviPageExtraInfo:(NSDictionary *)extraInfo;

/// 继续退出导航。
/// 如果shouldOverrideExitingPage返回NO，这个方法等同于exitPage
/// 如果shouldOverrideExitingPage返回YES，自定义方法里面不能直接用exitPage，需要用continueExitPage
/// @param exitType <#exitType description#>
/// @param animated <#animated description#>
/// @param extraInfo <#extraInfo description#>
- (void)continueExitPage:(BNavi_ExitPage_Type)exitType animated:(BOOL)animated extraInfo:(NSDictionary *)extraInfo;

/// 自定义是否展示导航UI。
/*
⚠️ 设置为YES时，表示以下回调才会触发。
- (void)onHandleShowNavigationViewController:(UINavigationController *)navigationViewController;
- (void)onHandleHideNavigationViewController:(UINavigationController *)navigationViewController;
*/
@property (assign, nonatomic) BOOL customShowUIEnable;

@optional

/**
 *  是否在导航过程页面
 */
- (BOOL)isInNaviPage;

#pragma mark - 自定义视图
/**
    关闭/打开导航中消息提示框
 */
- (void)shutdownNoticeMessage:(BOOL)shutdown;

/**
    关闭/打开干预消息提示框
 */
- (void)shutdonwInterveneMessage:(BOOL)shutdown;


@end



/// 导航UI管理器回调
@protocol BNNaviUIManagerDelegate <NSObject>

@optional

/**
 *  导航页面的调起controller
 *  可不实现，默认为最上层的controller
 */
- (id)naviPresentedViewController;


/// 是否覆盖导航提供的退出方法
/// @param exitType 退出类型
/// @param extraInfo 额外信息
- (BOOL)shouldOverrideExitingPage:(BNavi_ExitPage_Type)exitType  extraInfo:(NSDictionary*)extraInfo;


/// 如果shouldOverrideExitingPage返回YES，那么需要退出的时间点(点击退出按钮，到达目的地后超时等)，会调用下面的方法
/// overrideExitingPage里面不能直接调用exitPage方法，需要用continueExitPage
/// @param exitType 退出类型
/// @param extraInfo 额外信息
- (void)overrideExitingPage:(BNavi_ExitPage_Type)exitType animated:(BOOL)animated extraInfo:(NSDictionary*)extraInfo;

/**
 *  即将退出UI的回调
 *
 *  @param pageType  UI类型
 *  @param extraInfo 额外参数
 */
- (void)willExitPage:(BNaviUIType)pageType  extraInfo:(NSDictionary*)extraInfo;

/**
 *  退出UI的回调
 *
 *  @param pageType  UI类型
 *  @param extraInfo 额外参数
 */
- (void)onExitPage:(BNaviUIType)pageType  extraInfo:(NSDictionary*)extraInfo;
/// 专业导航中暴露出来的View
- (void)onHandleNaviViewDidLoad:(UIView*)naviView;

//自定义货车底部BottomBarView
- (UIView *)naviBottomBarView;
/*
要自定义导航控制器的展示方式，需设置 customShowUIEnable = YES 才能触发回调。
@param navigationViewController  SDK内部的导航控制器
*/
- (void)onHandleShowNavigationViewController:(UINavigationController *)navigationViewController;
/*
要自定义SDK导航控制器的隐藏方式，需设置 customShowUIEnable = YES 才能触发回调。
@param navigationViewController  SDK内部的导航控制器
*/
- (void)onHandleHideNavigationViewController:(UINavigationController *)navigationViewController;

@end

#endif
