//
//  BNStrategyManagerProtocol.h
//  baiduNaviSDK
//
//  Created by Baidu on 11/10/13.
//  Copyright (c) 2013 baidu. All rights reserved.
//

/**
 *  导航策略管理器协议,包含导航过程中的设置项、电子狗的设置策略以及导航入口记录
 *
 */

#ifndef baiduNaviSDK_BNStrategyManagerProtocol_h
#define baiduNaviSDK_BNStrategyManagerProtocol_h

#import "BNCommonDef.h"
#import "BMTruckInfoModel.h"
#import "BNMotorInfoModel.h"


/// 策略管理接口
@protocol BNStrategyManagerProtocol

@required

/// 恢复到默认策略
- (void)reset;  __deprecated_msg("废弃(空实现),功能已下线");

/// 停车场推送
@property (nonatomic, assign) BOOL parkInfo;

/// 日夜模式
@property (nonatomic, assign) BNDayNight_CFG_Type dayNightType;

/// 实际的日夜模式 (日 or 夜)
@property (nonatomic, assign) BNDayNight_Type realDayNightType;;

/// 播报模式
@property (nonatomic, assign) BN_Speak_Mode_Enum speakMode;

/// 诱导面板模式
@property (nonatomic, assign) BN_Simple_Guide_Mode simpleGuideMode; __deprecated_msg("废弃接口(空实现),自7.0.0起废弃,不支持诱导面板切换");

/// 是否显示实景放大图
@property (assign, nonatomic) BOOL showLiveExpandRoadMap;

/// 显示viaduct桥区
@property (nonatomic, assign) BOOL showViaduct; __deprecated_msg("废弃(空实现),功能已下线");

/// 显示智能比例尺开关
@property (nonatomic, assign) BOOL autoLevelShow;

/// 显示到终点红线开关
@property (nonatomic, assign) BOOL redLineShow;

/// 小窗
@property (nonatomic, assign) BOOL showMapTinyView;

/// 横屏开启
@property (nonatomic, assign) BOOL canLandscape; __deprecated_msg("废弃(空实现),自6.2.0起废弃,功能已下线");

/// 是否支持手势旋转，需要在引擎初始化成功后调用，默认YES
@property (nonatomic, assign) BOOL supportRotation; __deprecated_msg("废弃(空实现),自6.2.0起废弃,功能已下线");

/// 对底图操作是否需要惯性，需要在引擎初始化成功后调用，默认YES
@property (nonatomic, assign) BOOL operationInertia;  __deprecated_msg("废弃(空实现),自6.2.0起废弃,功能已下线");

/// 是否开启多路线，需要在算路前设，默认YES
@property (nonatomic, assign) BOOL enableMultiRoute;

/// 是否支持更多设置功能，默认YES
@property (nonatomic, assign) BOOL supportMoreSettings;

/// 导航设置面板是否开放路线偏好功能入口，默认YES
@property (nonatomic, assign) BOOL supportPreference; __deprecated_msg("废弃");

/// 导航设置面板是否开放沿途检索功能入口，默认YES
@property (nonatomic, assign) BOOL supportPoiSearch;  __deprecated_msg("废弃");

/// 导航设置面板是否开放横屏导航功能入口，默认YES
@property (nonatomic, assign) BOOL supportLandscape; __deprecated_msg("废弃");

/// 进入导航页面是否需要弹“已连接蓝牙...”toast，默认YES，使用内部TTS播报时有效，否则返回NO
@property (nonatomic, assign) BOOL showBluetoothToast;

/// 是否支持蓝牙设置功能，默认YES，使用内部TTS播报时有效，否则返回NO
@property (nonatomic, assign) BOOL supportBluetoothSettings;

/// 是否支持UGC上报功能，默认YES  已废弃 ⚠️  请使用[BNaviService_NaviSet setUGCReportButtonHidden:YES];
@property (nonatomic, assign) BOOL supportUGCReportButton __deprecated_msg("废弃。请使用BNaviService_NaviSet中的UGCReportButtonHidden");

/// 是否显示当前路名
@property (nonatomic, assign) BOOL showCurrentRoadName;

/// 是否显示车道线
@property (nonatomic, assign) BOOL showLanesView;   __deprecated_msg("废弃");

/// 是否显示区间测速
@property (nonatomic, assign) BOOL showIntervalSpeedView;

/// 是否显示高速信息面板
@property (nonatomic, assign) BOOL showHighwayInfoPanel;

/// 是否显示出口方向面板
@property (nonatomic, assign) BOOL showExitDirectionPanel;

/// 是否显示主辅路切换
@property (nonatomic, assign) BOOL showMainAuxiliaryButton;
//
///// 是否显示桥上桥下切换
//@property (nonatomic, assign) BOOL showOnOrUnderBridgeButton;

/// 是否显示导航工具箱
@property (nonatomic, assign) BOOL showNaviToolbox; __deprecated_msg("废弃");

/// 是否显示路况开关
@property (nonatomic, assign) BOOL showRoadConditionButton;  __deprecated_msg("废弃");

///// 是否显示声音模式选择  已废弃 ⚠️  请使用[BNaviService_NaviSet setBroadcastButtonHidden:YES];
@property (nonatomic, assign) BOOL showMuteButton __deprecated_msg("废弃。请使用BNaviService_NaviSet中的 broadcastButtonHidden");
//
///// 是否显示路线刷新  已废弃 ⚠️  [BNaviService_NaviSet setRefreshButtonHidden:YES];
@property (nonatomic, assign) BOOL showRrefreshRouteButton __deprecated_msg("废弃。请使用BNaviService_NaviSet中的refreshButtonHidden");
/// 是否显示缩放按钮
@property (nonatomic, assign) BOOL showZoomButton;   __deprecated_msg("废弃");
 
/// 货车限行提示view
@property (nonatomic, assign) BOOL supportTruckRestrictionView;

#pragma mark simulator

/// 模拟器速度控制按钮
@property (nonatomic, assign) BOOL supportSimulatorSpeedControl;

/// 模拟器暂停按钮
@property (nonatomic, assign) BOOL supportSimulatorPauseButton;

/// 模拟器路况条(barchartView)
@property (nonatomic, assign) BOOL supportRoadConditionBar;

/// 全览按钮
@property (nonatomic, assign) BOOL supportViewAllButton __deprecated_msg("废弃");
/// 底部工具栏 和 左右上报按钮 中间的间隙， 默认0
@property (nonatomic, assign) CGFloat toolBarViewTopSpace;
/// 底部需要预留的高度， 用于填充自身控件默认0
@property (nonatomic, assign) CGFloat bottomButtonHeight;

/// 底部工具栏的Y值
@property (nonatomic, assign, readonly) CGFloat carBottomButtonTop;
/// 车标偏移量
@property (nonatomic, assign) CGFloat naviLocationOffset;
///退出导航的时候 设置是否 销毁TTS  默认YES。设置为NO TTS会 占用部分内存不释放。需要开发者自己手动释放内存
@property (nonatomic, assign) BOOL exitNaviDestroyTTS;

//是否使用iOS 系统的TTS库，默认为NO，如果设置为YES，可以去掉导航SDK自带的TTS库
@property (nonatomic, assign) BOOL useSystemTTS;

///// 是否显示通知型消息
@property (nonatomic, assign) BOOL supportNoticeMessage;
//
///// 是否显示干预性消息
@property (nonatomic, assign) BOOL supportInterveneMessage;

//是否使用途经点偏好算路  默认 是NO。
//如开启途经点算路。起点可以添加偏好设置。
//路线偏好传入值为无效。起点没有设置偏好，默认设置智能推荐
//只有设置为YES 才启用途经点算路。只针对本次导航生效。
@property (nonatomic, assign) BOOL multiplePreferenceEnable;
///设置偏航后回到用户指定路线导航 /** 货车SDK偏航路线模式0 默认策略，1 偏航路线api提供，2 偏航回进入导航时选的路线*/
@property (nonatomic, assign) int yawSpecifiedRouteNavigation;
//是否允许点击路况条。YES-允许，NO-不允许,默认允许
@property (nonatomic, assign) BOOL tapBarChartViewEnable;
//能避开拥堵时路况条是否显示“避开”。YES-显示。NO-不显示。默认显示。
@property (nonatomic, assign) BOOL showAvoidJamEnable;
///是否支持 后台模拟导航。
/// 默认不支持。
/// 进导航前调用。 
@property (nonatomic, assign) BOOL supportBackgroundSimulatedNavi;

///是否展示路线上气泡。 YES展示。NO隐藏。默认 是YES
@property (nonatomic, assign) BOOL showRouteBubble;
///设置当前导航版本。使用方式：在算路前使用
@property (nonatomic, assign) BNaviLanguageType naviLanguageType;

///退出导航确认面板是否需要弹出。 默认弹出 YES
@property (nonatomic, assign) BOOL showExitPrompt;
/**
 *  设置路况是否开启，路况开启需要联网，没有网络，开启路况会失败
 *
 *  @param showTraffic 是否显示路况，默认显示
 *  @param success     成功的回调
 *  @param fail        失败的回调
 */
- (void)trySetShowTrafficInNavi:(BOOL)showTraffic success:(void (^)(void))success  fail:(void (^)(void))fail;

/**
 * 设置驾车车牌（BNTruckCarTypeCommon类型）
 * @param carNumber 车牌号, 格式如:"粤B00000"
 */
- (void)syncCarNumber:(NSString *)carNumber;


/**
 * 设置驾车车牌（支持普通和新能源）
 * @param carNumber 车牌号, 格式如:"粤B00000"
 *  @param type 车牌号, 格式如:"BNTruckCarTypeCommon、BNTruckCarTypeEnegry
 */
- (void)syncCarNumber:(NSString *)carNumber carType:(BNTruckCarType)type;

/**
 * 获取驾车车牌（BNTruckCarTypeCommon类型）
 */
- (NSString *)getCarNumber;
/**
 * 设置驾车车牌（支持普通和新能源）
 * @param carModel 车牌model
 */
- (void)syncCarModel:(BMCarInfoModel *)carModel;
/**
 * 获取驾车车牌
 */
- (BMCarInfoModel *)getCarModel;
/**
 * 开关导航声音
 * @param turnOn 是否开启导航声音
 * @return 开关导航声音是否成功
 */
- (BOOL)soundTurnOn:(BOOL)turnOn;

/**
 * 设置货车信息
 */
- (void)syncTruckInfoModel:(BMTruckInfoModel *)model;

/**
 * 获取货车信息
 */
- (BMTruckInfoModel *)getTruckInfoModel;

///设置货车用途
-(void)syncTruckUse:(BNaviTruckUse)truckUse;


/// 设置摩托车车牌相关信息，不持久化保存
/// @param model 摩托车车牌
- (void)syncMotorInfoModel:(BNMotorInfoModel *)model;


@end

#endif
