//
//  BNSoundProtocol.h
//  BNOpenKit
//
//  Created by linbiao on 2019/3/19.
//  Copyright © 2019年 Chen,Xintao. All rights reserved.
//

#ifndef BNSoundProtocol_h
#define BNSoundProtocol_h

#import <Foundation/Foundation.h>
#import "BNCommonDef.h"

/// 播报相关回调接口
@protocol BNNaviSoundDelegate <NSObject>

/**
 *  TTS文本回调
 *  text： 播报的文案。
 *@param userInfo 额外信息，非自定义偏航播报时穿空值（nil）
 *@param key1 : type （自定义偏航播报时userInfo中会传该key），value: BNaviTTSType（枚举值）
 */
- (void)onPlayTTS:(NSString*)text userInfo:(nullable NSDictionary *)userInfo;

/**
 *  TTS音效回调
 *  @param type 音效类型
 *  @param filePath 音频文件路径
 */
- (void)onPlayVoiceSound:(BNVoiceSoundType)type filePath:(NSString *)filePath;

/**
 *  播报或进入导航的时候都会检测TTS是否鉴权成功
 *  (1)如果还没鉴权成功，会尝试先鉴权，然后回调鉴权结果，
 *  (2)如果已经鉴权成功，也会回调鉴权成功
 */
- (void)onTTSAuthorized:(BOOL)success;

/**
*  使用自定义的tts播报，需要在此回调外部tts是否正在播报，sdk内部会根据播报状态判断是否继续回调文案
*  @return 返回自定义TTS是否在播报
*/
- (BOOL)ttsIsPlaying;

@end

/// 播报相关接口
@protocol BNSoundProtocol <NSObject>

/**
 *  设置导航播报的delegate
 */
- (void)setSoundDelegate:(id<BNNaviSoundDelegate>)delegate;


/// 释放TTS单例
- (void)releaseInstance;

@end

#endif /* BNSoundProtocol_h */
