//
//  BNRoutePlanManagerProtocol.h
//  baiduNaviSDK
//
//  Created by Baidu on 11/10/13.
//  Copyright (c) 2013 baidu. All rights reserved.
//

#ifndef baiduNaviSDK_BNRoutePlanManagerProtocol_h
#define baiduNaviSDK_BNRoutePlanManagerProtocol_h

#import "BNRoutePlanModel.h"
// 货车 是否需要服务下发强切 默认下发强切、 0下发强切、 1不下发强切。
extern NSString* BNaviForceSwitchInValidKey;

// 导航算路类型 (区分驾车、货车)
extern NSString* BNaviTripTypeKey;

// 额外的算路参数
extern NSString* BNaviRoutePlanAssignKey;

// 导航算路未来时间算路参数（未来出行开始时间）
extern NSString* BNaviTripeBeginTimeKey;
/**
 *  导航算路入口
 */

@class BNaviRoutePlanNode;
@protocol BNNaviRoutePlanDelegate;

extern NSString* const BNDriveRouteDataKey;


/// 算路接口
@protocol BNRoutePlanManagerProtocol

@required

/**
 *  发起算路
 *
 *  @param eMode     算路方式，定义见BNRoutePlanMode
 *  目前货车算路组合 可支持以下组合
 *  时间优先+不走高速                      BNRoutePlanMode_SaveTime|BNRoutePlanMode_NoHeighWay;
 *  少收费+不走高速                         BNRoutePlanMode_LessToll | BNRoutePlanMode_NoHeighWay;
 *  躲避拥堵+不走高速                     BNRoutePlanMode_LessJam | BNRoutePlanMode_NoHeighWay;
 *  躲避拥堵+少收费                         BNRoutePlanMode_LessJam | BNRoutePlanMode_LessToll;
 *  躲避拥堵+少收费+不走高速        BNRoutePlanMode_LessJam | BNRoutePlanMode_LessToll | BNRoutePlanMode_NoHeighWay;
 *  躲避拥堵+高速优先                     BNRoutePlanMode_LessJam | BNRoutePlanMode_MainRoad;
 *  @param naviNodes 算路节点数组，起点、途经点、终点按顺序排列，节点信息为BNRoutePlanNode结构
 *  @param naviTime  发起算路时间，用于优化算路结果,可以为nil
 *  @param delegate  算路委托，用于回调
 *  @param userInfo  用户需要传入的参数，货车导航算路需要传入BNaviTripTypeKey，值为BN_NaviTypeTruck
 * 支持传入参数：
 *BNaviTripTypeKey：NSNumber *， 可选，BN_NaviType类型，不传默认为驾车。
 *（1）货车，传@(BN_NaviTypeTruck)
 *（2）驾车，传@（BN_NaviTypeReal）
 *（3）摩托车，传@(BN_NaviTypeMoto)
 */
- (void)startNaviRoutePlan:(BNRoutePlanMode)eMode
                naviNodes:(NSArray*)naviNodes
                     time:(BNaviCalcRouteTime*)naviTime
                 delegete:(id<BNNaviRoutePlanDelegate>)delegate
                 userInfo:(NSDictionary*)userInfo;


/**
 *  获得当前节点总数
 *
 *  @return 当前节点总数
 */
- (NSInteger)getCurNodeCount;


/**
 *  获得第index个节点
 *
 *  @param index 节点序号
 *
 *  @return 第index个节点
 */
- (BNRoutePlanNode*)getNaviNodeAtIndex:(NSInteger)index;


/**
 *  设置算路节点
 *
 *  @param naviNodes 算路节点
 */
- (void)setNaviNodes:(NSArray*)naviNodes;


/**
 *  获取当前的路线规划方式
 *
 *  @return 当前的路线规划方式
 */
- (int)getCurRoutePlanMode;

/**
 * 获取选择的路线索引
 * return 路线索引
 */
- (NSInteger)GetCurrentSelectRouteIdx;


/// 选路，注意，这是一个异步的过程
/// @param routeIndex 路线序号，从0开始
- (BOOL)selectRouteIndex:(NSInteger)routeIndex;


/// 选路，注意，这是一个异步的过程
/// @param routeIndex 路线序号
/// @param completion 选路完成的回调
- (BOOL)selectRouteIndex:(NSInteger)routeIndex completion:(dispatch_block_t)completion;


/**
 *	获取当前规划方式的路线详情信息
 *  param [in] stRouteIdx   路线下标    多路线为选择的路线下标，单路线就传0
 *	@return	返回路线详情信息
 */
- (BNRouteDetailInfo*)getCurrentRouteDetailInfo:(int)stRouteIdx;

/**
 *	获取当前用户保存的算路偏好
 */
- (int)getCurrentPreference;

//是否显示多路线
- (void)showMultiRoute:(BOOL)show;

///导航偏航回调 偏航前的原因 数组
-(NSArray<BNaviRouteEventItemModel*> *)getLeftRoadEventForYaw;

///货车限行区域 设置
- (void)truckNaviSettingTrafficControl:(BOOL)islimit;

///道路限重区域 设置
- (void)truckNaviSettingWeightControl:(BOOL)islimit;

///货车限行区域 状态
- (BOOL)driveAreaLimitSwitchIsOn;

///道路限重区域 状态
- (BOOL)weightLimitSwitchIsOn;


@optional

@property (nonatomic, assign) BOOL disableOpenUrl;

@property (nonatomic) NSString *customRoutePlanUrl;

@end


/// 算路回调
@protocol BNNaviRoutePlanDelegate <NSObject>

@optional

/**
 *  算路成功回调
 *
 *  @param userInfo 用户信息
 */
- (void)routePlanDidFinished:(NSDictionary*)userInfo;

/**
 *  检索成功回调
 *
 *  @param userInfo 用户信息
 */
- (void)searchDidFinished:(NSDictionary*)userInfo;

/**
 *  算路失败回调
 *
 *  @param error    失败信息
 *  @param userInfo 用户信息
 */
- (void)routePlanDidFailedWithError:(NSError *)error andUserInfo:(NSDictionary*)userInfo;

/**
 *  算路取消
 *
 *  @param userInfo 用户信息
 */
-(void)routePlanDidUserCanceled:(NSDictionary*)userInfo;

/**
 *  更新路况成功回调
 *
 *  @param pbData pb数据
 */
- (void)updateRoadConditionDidFinished:(NSData *)pbData;

/**
 *  更新路况成功失败
 *
 *  @param pbData pb数据
 */
- (void)updateRoadConditionFailed:(NSData *)pbData;

@end

#endif
