//
//  BNNaviSettingDef.h
//  BNOpenCommonKit
//
//  Created by v_xudihua on 2022/9/16.
//  Copyright © 2022 Chen,Xintao. All rights reserved.
//

#ifndef BNNaviSettingDef_h
#define BNNaviSettingDef_h


/** 实际播报模式 */
typedef enum {
    BN_SpeakMode_Real_Play,           /**< 导航播报 */
    BN_SpeakMode_Real_Ding,             /**< 仅提示音 */
    BN_SpeakMode_Real_Mute              /**< 静音    */
} BN_SpeakMode_Real_Enum;
/**
 播报内容设置
 **/
typedef enum {
    BN_BroadCast_Content_Simple = 0,      //简洁
    BN_BroadCast_Content_Standard,        //标准
    BN_BroadCast_Content_Detailed,        //详细
    BN_BroadCast_Content_DIY              //自定义
}BN_BroadCast_Content_Mode;

/**
 导航视角设置
 **/
typedef enum {
    BN_Navi_Perspective_Head = 0,      //跟随车头
    BN_Navi_Perspective_North,         //正北朝上
    BN_Navi_Perspective_Hud           //HUD
}BN_Navi_Perspective_Mode;

/**
 智能比例尺设置
 **/
typedef enum {
    BN_Navi_SmartScale_Close,        //关闭
    BN_Navi_SmartScale_Open,        //开启
}BN_Navi_SmartScale_Mode;

/**
 路况开关
 **/
typedef enum {
    BN_Navi_RoadCondition_Close,        //关闭
    BN_Navi_RoadCondition_Open,         //开启
}BN_Navi_RoadCondition_Mode;

#endif /* BNNaviSettingDef_h */

