//
//  BNNaviSettingDataManagerProtocol.h
//  BNOpenCommonKit
//
//  Created by v_lisisi on 2023/4/19.
//  Copyright © 2023 Chen,Xintao. All rights reserved.
//
#import <Foundation/Foundation.h>
#import "BNNaviSettingDef.h"
@protocol BNaviSettingListenerManagerDelegate <NSObject>

/**播报设置：导航播报、静音、仅提示音*/
- (void)onHandleDidSettingBroadCast:(BN_SpeakMode_Real_Enum)mode;

/**播报内容：简洁、标准、详细、自定义*/
- (void)onHandleDidSettingBroadCastContent:(BN_BroadCast_Content_Mode)mode;

/**导航视角：跟随车头、正北朝上、HUD*/
- (void)onHandleDidSettingNavigationPerspective:(BN_Navi_Perspective_Mode)mode;

/**日夜模式：自动、白天、夜间*/
- (void)onHandleDidSettingDayNightMode:(BNDayNight_CFG_Type)mode;

/**智能比例尺：开启、关闭*/
- (void)onHandleDidSettingSmartScale:(BN_Navi_SmartScale_Mode)mode;

/** 实时路况开关 */
- (void)onHandleDidRoadConditionSwitch:(BN_Navi_RoadCondition_Mode)mode;

/**导航中偏好*/
- (void)onHandleDidNaviRoutePreferences:(BNRoutePlanMode)preference;

@end


@interface BNaviSettingModel : NSObject
///如果设置成YES 整个设置栏全会隐藏 默认是NO
@property (nonatomic, assign) BOOL hidden;

@end
 /// 导航显示
@interface BNaviSettingShowModel : BNaviSettingModel
///导航视角
@property (nonatomic, assign) BOOL hiddenNaviPerspective;
///HUD
@property (nonatomic, assign) BOOL hiddenHUD;
///日夜模式
@property (nonatomic, assign) BOOL hiddenDayNight;
///导航比例尺
@property (nonatomic, assign) BOOL hiddenSmartScale;
///车道级
@property (nonatomic, assign) BOOL hiddenMapLane;
@end
/// 导航语音
@interface BNaviSettingVoiceModel : BNaviSettingModel
///播报类型
@property (nonatomic, assign) BOOL hiddenNaviBroadcastMode;
///导航播报内容
@property (nonatomic, assign) BOOL hiddenNaviTTSContent;
@end
/// 导航路线
@interface BNaviSettingRoutePreferenceModel : BNaviSettingModel
/// 路线偏好
@property (nonatomic, assign) BOOL hiddenRoutePreference;
@end
/// 快捷功能
@interface BNaviSettingShortCutModel : BNaviSettingModel
/// 沿途搜
@property (nonatomic, assign) BOOL hiddenYantuSearchType;
/// 问题上报
@property (nonatomic, assign) BOOL hiddenProblemUploadType;
/// 自定义导航
@property (nonatomic, assign) BOOL hiddenDIYNaviTypes;
/// 实时路况
@property (nonatomic, assign) BOOL hiddenRoadCondition;

@end
/// 辅助功能
@interface BNaviSettingAssistModel : BNaviSettingModel

/// 蓝牙播报
@property (nonatomic, assign) BOOL hiddenBlueTooth;
@end
///导航中 开关设置项 
@protocol BNNaviFixedButtonHiddenProtocol <NSObject>

/**
 设置沿途搜按钮的显示状态
 */
@property (nonatomic, assign) BOOL alongRouteSearchButtonHidden;

/**
 设置播报按钮的显示状态
 */
@property (nonatomic, assign) BOOL broadcastButtonHidden;

/**
 设置刷新按钮的显示状态
 */
@property (nonatomic, assign) BOOL refreshButtonHidden;

/**
 设置设置按钮的显示状态
 */
@property (nonatomic, assign) BOOL settingsButtonHidden;

/**
 设置模式切换按钮的显示状态
 */
@property (nonatomic, assign) BOOL modeSwitchButtonHidden;

/**
 设置上报按钮的显示状态
 */
@property (nonatomic, assign) BOOL UGCReportButtonHidden;

@end

@protocol BNNaviSettingDataManagerProtocol <BNNaviFixedButtonHiddenProtocol>

/**
 添加导航设置监听

 @param listener 监听者
 */
- (void)addSettingListener:(id<BNaviSettingListenerManagerDelegate>)listener;

/**
 移除导航设置监听

 @param listener 监听者
 */
- (void)removeSettingListener:(id<BNaviSettingListenerManagerDelegate>)listener;

/// 设置导航语音 模块
- (void)setVoiceModel:(BNaviSettingVoiceModel *)model;
/// 设置导航显示 模块
- (void)setShowModel:(BNaviSettingShowModel *)model;
///设置 导航路线 模块
- (void)setRoadPreferenceModel:(BNaviSettingRoutePreferenceModel *)model;
///设置 快捷功能  模块
- (void)setShortCutModel:(BNaviSettingShortCutModel *)model;
/// 设置辅助功能 模块
- (void)setAssistModel:(BNaviSettingAssistModel *)model;

@end
 
