//
//  BNNaviProtocol.h
//  NaviDemo
//
//  Created by linbiao on 2019/3/20.
//  Copyright © 2019年 Baidu. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "BNNaviMessageInfo.h"
#import "BNCommonDef.h"
#import <UIKit/UIKit.h>
NS_ASSUME_NONNULL_BEGIN

@class BNaviModel;
@class BNCarRouteModel;
@class BNRoutePlanNode;
@class BNaviLanesIconModel;
@class BNGuideViewCombinationModel;
@class BNaviExpandGuideModel;

@protocol BNaviModelUIDelegate <NSObject>
@optional
/**
 *  高速服务区面板数据
 *  BNaviHighwayPanelModel
 */
- (void)onHandleHighwayPanelChange:(BNaviHighwayPanelModel *)model;

/**
 *  车道线显隐变化
 *
 *  @param param 车道线显隐变化消息
 */
- (void)onHandleNaviLaneInfoChanged:(BNaviLaneInfo *)param withLanesIcons:(NSArray<BNaviLanesIconModel*> *)array;

/**
 * GPS速度变化回调
 * @param speed 当前速度 -1 代表 需要展示 --  单位:km/h
 * @param speedLimit  单位:km/h   在无限速的情况下是0
 */
- (void)onHandleGPSSpeedChange:(BNKMNaviSpeed *)speed speedLimit:(int)speedLimit;

/**
 * 区间速度码表 回调
 * @param speedInfoModel :
 * 用 state 区分当前进入区间测速状态。
 */
- (void)onHandleIntervalSpeedChange:(BNIntervalSpeedModel *)speedInfoModel;

/**
 *  处理路口动态放大图消息
 *  rasterExpandMap是对外的view视图。
 *  注意事项：
 *  1、不可以对rasterExpandMap进行frame、bound的修改，仅做外部截屏使用。
 *  2、rasterExpandMap是手机导航内部使用的view，禁止将rasterExpandMap 添加在其他view上（[self.view addSubview:rasterExpandMap]），或将其他自定义view 添加在rasterExpandMap之上（[rasterExpandMap addSubview:自定义View]）。
 *  3、禁止将rasterExpandMap  =  nil；禁止 [rasterExpandMap removeFromSuperview];
 *  */
- (void)onHandleExpandMap:(UIView *)rasterExpandMap guideModel:(BNaviExpandGuideModel *)model;

/**
 * 路况更新
 *
 */
- (void)onHandleRoadConditionChange:(BNaviRoadConditionModel *)model;

/**
 *  诱导面板UI数据
 *
 */
- (void)onHandleNewSimpleGuideUIInfo:(BNGuideViewCombinationModel *)data;

/**
 * 导航GPS信号内容展示
 *
 */
- (void)onHandleSignalStatusChange:(BNaviSignalModel *)model;

/**
 *  处理当前路名变化接口
 *
 *  @param curRoadName 当前路名信息
 */
- (void)onHandleCurrentRoadName:(BNaviCurrentRoadName*)curRoadName;

/**
 *  处理剩余信息
 *
 *  @param remainInfo 剩余信息
 */
- (void)onHandleRemainInfo:(BNaviRemainInfo*)remainInfo;

/**
* 剩余信息 + 到达
* - Parameter remainInfo: eta数据
 */
- (void)onHandleRemainUIInfo:(BNaviEtaRemainUIInfo *)remainInfo;
/**
 *  处理剩余红绿灯信息
 *
 */
- (void)onHandleRemainTrafficlightsInfo:(BNaviRemainTrafficlightsInfo*)remainTrafficlightsInfo;

/**
 *  车标位置进度变化
 */
- (void)onHandleCarProgressChange;

@end
/// 导航中的事件回调
@protocol BNaviModelDelegate <NSObject, BNaviModelUIDelegate>

@optional
/**
 * 导航更新路线前回调
 */
- (void)onHandleNaviRouteWillChangedByType:(BNCalculateSourceType)type;
/**
 * 导航中更新 途径点  终点 成功或者失败回调。error != nil 是成功
 */
/// type 算路当前算路的类型。删除途经点  添加途经点  更改终点 类型
/// @param node 途经点
/// @param index 途径点下标序号 从1 开始
/// @param error 失败错误
- (void)onHandleNaviRouteDidChangedByType:(BNCalculateSourceType)type node:(BNRoutePlanNode *)node  index:(int)index error:(NSError *)error;

///开始刷新路线
- (void)onHandleNaviRouteWillRefresh;
///刷新路线返回刷新结果类型
- (void)onHandleNaviRouteDidRefreshWithType:(BNaviMessage_OtherRoute_Enum)type;
/** 强切路线
 @param dict =  {
    @"reasonText":  原因 NSString 类型
    @"time": 强切时间 时间戳 NSString 类型
    @"position": 当前定位 BNPosition 类型 当 BNPosition 为空 则没有这个key
    @"remainDist": 剩余距离单位是 米 NSString 类型
 }
 */
- (void)onHandleNaviRouteDidForceSwitchResult:(NSDictionary *)dict;

/**
 * 导航中更改路线成功
 */
- (void)reCalculateNaviRouteDidFinished:(BNaviModel *)model sourceType:(BNCalculateSourceType)sourceType;

/**
 * 导航中更改路线失败
 */
- (void)reCalculateNaviRouteDidFailed:(BNaviModel *)model sourceType:(BNCalculateSourceType)sourceType;

/**
 * 导航中取消更改路线
 */
- (void)reCalculateNaviRouteDidCancel:(BNaviModel *)model sourceType:(BNCalculateSourceType)sourceType;

/**
 * 导航中开始偏航
 */
- (void)naviYawingDidStart:(BNaviModel *)model withStamp:(NSString *)yawingStamp;

//- (void)naviYawingDidStart:(BNaviModel *)model withStamp:(int)yawingStamp;
/**
 * 沿途搜索结果
 * @param code 沿途搜索结果
 * @param poiArray 当code为BNaviSearch_ResultCode_Succeed时，poiArray返回搜索结果
 */
- (void)viaSearchResult:(BNaviSearch_ResultCode_ENUM)code poiArray:(NSArray *)poiArray;

/**
 * 清空沿途搜索结果
 */
- (void)viaSearchClearResult;

/**
 *  回调规避提示
 *
 *  @param tips 规避提示
 */
- (void)onHandleNaviLocalRouteTips:(NSString *)tips;

/**
 *  导航中白天黑夜模式变化回调
 *
 *  @param dayNightType 当前白天黑夜模式
 */
- (void)onHandleDayNightTypeChange:(BNDayNight_Type)dayNightType;

/**
 *  GPS速度变化回调
 *
 *  @param speed GPS速度
 */
- (void)onHandleGPSSpeedChange:(BNKMNaviSpeed *)speed __deprecated_msg("废弃。请使用 -(void)onHandleGPSSpeedChange:(BNKMNaviSpeed *)speed speedLimit:(int)speedLimit");


/**
 *  处理导航状态变化接口
 *
 *  @param naviStatusInfo 导航状态信息
 */
- (void)onHandleNaviStatusChange:(BNaviStatusInfo*)naviStatusInfo;

/**
 *  处理建议诱导消息接口
 *
 *  @param simpleGuideInfo 简易诱导消息
 */
- (void)onHandleSimpleGuideInfo:(BNaviSimpleGuideInfo*)simpleGuideInfo;

/**
 *  简易诱导消息隐藏
 *
 *  @param simpleGuideInfo 简易诱导消息
 */
- (void)onHandleSimpleGuideInfoHide:(BNaviSimpleGuideInfo*)simpleGuideInfo;

/**
 *  处理路口放大图消息
 *
 *  @param rasterExpandMap 路口放大图信息
 */
- (void)onHandleRasterExpandMap:(BNaviRasterExpandMap*)rasterExpandMap;


/**
 *  处理gps状态变化
 *
 *  @param gpsChangeInfo gps状态
 */
- (void)onHandleGPSChange:(BNaviGPSChange*)gpsChangeInfo;

/**
 *  处理矢量放大图消息
 *
 *  @param vectorExpandMap 矢量放大图信息
 */
- (void)onHandleVectorExpandMap:(BNaviVectorExpandMap*)vectorExpandMap;
/**
 *  放大图消息
 *
 */
- (void)onHandleExpandViewHiddenChange:(BOOL)hidden;
/**
 * 路况条 类型
 *
 */
- (void)onHandleRoadConditionTypeChange:(BNNaviRoadConditionType)type;

/**
 *  车道级状态
 */
- (void)onHandleNavigationMapLaneMode:(BNMultiMapsStatus)status;
/**
 * 车道级路线自动 进入和 退出 消息
 */
- (void)onHandleNavigationMapLaneMsg:(BOOL)isEnter;
/**
 *  处理高速面板消息
 *
 *  @param highWayBoard 高速面板消息类型
 */
- (void)onHandleHighWayBoard:(BNaviHighwayBoard*)highWayBoard;

/**
 *  处理高速入口消息
 *
 */
- (void)onHandleInHighwayBoard:(BNaviInHighwayBoard *)inHighwayBoard;

/**
 *  处理方向看板消息
 *
 *  @param directionBoard 方向看板消息
 */
- (void)onHanldeDirectionBoard:(BNaviDirectionBoard *)directionBoard;

/**
 *  处理地图刷新相关信息
 *
 *  @param mapRefreshInfo 地图刷新消息
 */
- (void)onHandleMapRefresh:(BNaviMapRefreshInfo*)mapRefreshInfo;

/*
 *  高架桥，主辅路显示
 *
 *  @param msg
 */
- (void)onHandleMainSlaveViaductChange:(BNaviMainSlaveViaductInfo *)changeInfo;
/**
 *  高架桥，主辅路切换结果消息
 *
 *  @param msg 高架桥主辅路切换消息
 */
- (void)onHandleMainSlaveViaductInfoResult:(BNaviMainSlaveViaductMsg *)msg;

/**
 *  经过途经点/偏航时移除途经点消息
 *
 *  @discussion 以下两种情况会回调该方法：
 *
 *  1.经过某个途经点时；
 *
 *  2.接近某个途经点并产生偏航，这是SDK会抛弃该途经点进行偏航算路并抛出该回调消息。
 *
 *  如何区分上面两种情况？
 *
 *  passViaInfo参数的属性enType==1时表示经过某个途经点，enType==2时表示偏航时该途经点被自动删除
 *
 *  @param passViaInfo 途经点消息
 *  @note passViaInfo参数的属性viaIndex表示正在经过/删除的是第几个途经点（编号从0开始）
 */
- (void)onHandlePassViaPoint:(BNaviPassViaPointInfo *)passViaInfo;

/// 货车限行标识（限高，限重等）显示
/// @param msgParam  货车限行消息结构体
- (void)onHandleTruckTrafficSignShow:(BNaviTruckTrafficSignInfo *)msgParam;

/// 货车限行标识（限高，限重等）更新
/// @param msgParam  货车限行消息结构体
- (void)onHandleTruckTrafficSignUpdate:(BNaviTruckTrafficSignInfo *)msgParam;

/// 货车限行标识（限高，限重等）隐藏
/// @param msgParam  货车限行消息结构体
- (void)onHandleTruckTrafficSignHide:(BNaviTruckTrafficSignInfo *)msgParam;

/// 导航中主路变化回调
/// @param routeModel 路线数据model
- (void)onHandleDrivingRouteChange:(BNCarRouteModel *)routeModel;
@end



/// 导航视图事件回调
@protocol BNaviViewDelegate <NSObject>

@optional
/**
 *  诱导面板点击事件回调
 */
- (void)onHandleGuideViewDidTap;

/**
 *  诱导面板双击事件回调
 */
- (void)onHandleGuideViewDidDoubleTap;

/**
 *  诱导面板转向图标点击事件回调
 */
- (void)onHandleGuideViewTurnIconDidTap;

/**
 *  全览小窗点击事件回调
 */
- (void)onHandleTinyMapViewDidTap;

/**
 *  全览按钮点击事件回调
 */
- (void)onHandleViewAllButtonDidTap;

/**
 *  刷新按钮点击事件回调
 */
- (void)onHandleViewRecalculateButtonDidTap;

/**
 *  底部工具栏点击事件回调
 */
- (void)onHandleBottomToolBarDidTap;

/**
 *  退出按钮点击事件回调
 */
- (void)onHandleExitButtonDidTap;

/**
 *  底图单击回调
 */
- (void)onHandleSingleTap:(CGPoint)tapPoint;

/**
 *  底图双击回调
 */
- (void)onHandleDoubleTap;

@end

NS_ASSUME_NONNULL_END
