//
//  BNNaviMessageInfo.h
//  NaviSDKDemo
//
//  Created by linbiao on 2018/12/25.
//  Copyright © 2018年 李择一. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "BNCommonDef.h"
#import <UIKit/UIKit.h>
/// 所有导航消息基类
@interface BNNaviMsgBase : NSObject

@property(nonatomic,assign)BNaviMessage_Type_Enum eMsgType; // 消息类型 - navigation message type

@end
/**
 *  eta UI 上 剩余信息（距离、时间、到达）
 *  -----------------
 *  Remain distance and time
 */
@interface BNaviEtaRemainUIInfo : NSObject
@property(nonatomic,copy)NSString *remainDist;                // 剩余距离 - remain distance
@property(nonatomic,copy)NSString *remainTime;                // 剩余时间 - remain time
@property(nonatomic,copy)NSString *arrivalTime;                 ///到达时间

@end

/// 导航中距离描述model
/*
 kmValue和mValue：为-1表示无效值，大于等于0为有效值。如果距离需要展示为km，则kmValue为有效值，mValue为无效值，如果距离需要展示为m，则mValue为有效值，kmValue为无效值。如果距离不需要用数字展示（比如可能展示【现在】），则kmValue和mValue均为无效值。
 distanceDescription：表示距离展示的UI数据，比如【8.9公里】【200米】、【现在】
 例子：
 导航中UI展示【8.9公里】，则kmValue为8.9，mValue为-1，distanceDescription为【8.9公里】
 导航中UI展示【200米】，则kmValue为-1，mValue为200，distanceDescription为【200米】
 导航中UI展示【现在】，则kmValue为-1，mValue为-1，distanceDescription为【现在】
 */
@interface BNaviDistanceDescriptionModel : NSObject
/// 单位是千米 1.1 表示 1.1km
@property (nonatomic, assign)  CGFloat kmValue;
/// 单位是米    889 表示 889m
@property (nonatomic, assign)  CGFloat mValue;
///距离 整体描述
@property (nonatomic, copy) NSString *distanceDescription;

@end

/// /// 导航中时间描述model
/*
 hour、minute、dayType为小时、分钟、天的原始数据，timeDescription为UI展示数据
 例子：
 全程剩余时间：
 （1）导航中UI展示【47小时57分】，hour为47，minute为57，dayType为BNaviDayType_Invalid，timeDescription为【47小时57分】
 （2）导航中UI展示【57分】，hour为0，minute为57，dayType为BNaviDayType_Today，timeDescription为【57分】
 到达时间：
 （1）导航中UI展示【13:02到达】，hour为13，minute为2，dayType为BNaviDayType_Today，timeDescription为【13:02】
 （2）导航中UI展示【明天23:33到达】，hour为23，minute为33，dayType为BNaviDayType_Tomorrow，timeDescription为【明天23:33】
 */
@interface BNaviTimeDescriptionModel : NSObject
/// 小时
@property (nonatomic, assign)  int hour;
/// 分钟
@property (nonatomic, assign)  int minute;
///天的 类型
@property (nonatomic, assign) BNaviDayType dayType;
///时间整体描述
@property (nonatomic, copy) NSString *timeDescription;

@end

/// 剩余信息（距离、时间）
@interface BNaviRemainInfo : BNNaviMsgBase

@property(nonatomic,assign)BNaviMessage_Action_Enum eAction;    // 动作类型 - action type
@property(nonatomic,assign)NSInteger remainDist;                // 剩余距离 - remain distance
@property(nonatomic,assign)NSInteger remainTime;                // 剩余时间 - remain time
/// 转化后 全程剩余时间
@property (nonatomic, strong) BNaviTimeDescriptionModel *remainingTimeModel;
/// 转化后 到达时间
@property (nonatomic, strong) BNaviTimeDescriptionModel *estimatedArrivalTimeModel;
/// 转化后 剩余距离
@property (nonatomic, strong) BNaviDistanceDescriptionModel *etaRemainingDistanceModel;
@end


/// 简易诱导消息结构体
@interface BNaviSimpleGuideInfo : BNNaviMsgBase
@property(nonatomic,assign)BNaviMessage_Action_Enum eAction;    // 动作类型 - action type
@property(nonatomic,copy)NSString* nextRoadName;                // 下一路口名字 - next road name
@property(nonatomic,copy)NSString* turnIconName;                // 转向标图片名称 - name for lane change information indicating diagram
@property(nonatomic,assign)NSInteger totalDist;                 // 该段路总长度，单位：米 - total length of the route, in meter
@property(nonatomic,assign)NSInteger remainDist;                // 距离下一路口剩余长度，单位：米 - remain distance to the next road, in meter
@property(nonatomic,assign)NSInteger remainTime;                // 距离下一路况大概时间，单位：秒 - remain time to the next road, in second
@property(nonatomic,assign)BOOL isStraight;                     //是否处于顺行模式
@property(nonatomic, assign)BOOL bStraightIcon;              //区分下一个路口是添加沿 还是进入
//下一转向
@property (nonatomic, assign) BNaviManeuver_Kind_Enum nextTurnKind;
//当前转向
@property (nonatomic, assign) BNaviManeuver_Kind_Enum curTurnKind;
//下一个转弯到当前转弯的距离
@property (nonatomic, assign) NSInteger distCur2NextGP;
//下一个转弯是否为高速
@property (nonatomic, assign) BOOL bHighwayExCur2NextGP;
//当前路名，顺行模式显示当前路名
@property (nonatomic, strong) NSString* curRoadName;
@property(nonatomic,assign)NSInteger GPAddDist; // 机动点距离，用于判断前后是否相同机动点
//随后下一路名
@property (nonatomic, copy) NSString *nextNextRoadName;
@end


/// 导航状态消息结构体
@interface BNaviStatusInfo : BNNaviMsgBase

@property(nonatomic,assign)BNaviStatus_Type_Enum eNaviStatusType; // 导航状态类型 - message type of navigation status
@property(nonatomic,assign)NSInteger eNaviSightType;              // 新增的导航状态类型

@end


/// 路口放大图消息结构体
@interface BNaviRasterExpandMap : BNNaviMsgBase
@property(nonatomic,assign)BNaviMessage_Action_Enum eAction;    // 动作类型 - Action type
@property(nonatomic,copy)NSString* bgImageId;                   // 背景图片id - ID for background image
@property(nonatomic,copy)NSString* iconId;                      // icon图片id - icon id
@property(nonatomic,retain)UIImage* bgImage;                    // 背景图片,下载了资源后才有,否则为nil - Need to download the corresponding data, otherwise, it will be nil.
@property(nonatomic,assign)NSInteger totalDist;                 // 总距离，单位：米 - total length, in meter
@property(nonatomic,assign)NSInteger remainDist;                // 剩余距离，单位：米 - remain distance, in meter
@property(nonatomic,assign)NSInteger remainTime;                // 剩余时间，单位：秒, remain time, in second
@property(nonatomic,copy)NSString * nextRoadName;               // 下一路口名字, next road name
@property(nonatomic,assign)BNaviRasterExpandMap_Type_Enum eRasterType;// 路口放大图类型, type of enlargement
@property (nonatomic, assign) int gridMapKind;                  //放大图分类，用于统计，详见RG_Grid_Kind_Enum类型
@property (nonatomic, copy) NSString *statParam; //诱导统计字段
@property(nonatomic,copy)NSString * straightIcon;               // 不为空就是直行路口
@property (nonatomic, assign)NSInteger addDist;                 //积算距离

@end


/// 当前路名信息
@interface BNaviCurrentRoadName : BNNaviMsgBase

@property(nonatomic,copy)NSString* curRoadName; // 当前路名, current road name

@end


/// 剩余红绿灯（目的地、途经点）
@interface BNaviRemainTrafficlightsInfo : BNNaviMsgBase

@property(nonatomic,assign)NSInteger remainTrafficights;                // 离目的地剩余红绿灯
@property(nonatomic,assign)NSInteger viaRemainTrafficights;             // 离下个途经点剩余红绿灯

@end


/// gps连接状态变化消息
@interface BNaviGPSChange : BNNaviMsgBase

@property(nonatomic,assign)BNaviGPS_Change_Enum eGpsChangeType; // 状态变化 - change type for gps

@end

/// 矢量放大图消息
@interface BNaviVectorExpandMap : BNNaviMsgBase

@property(nonatomic,assign)BNaviMessage_Action_Enum eAction;    // 动作类型 - action type
@property(nonatomic,assign)NSInteger totalDist;                 // 总距离，单位：米 - total distance, in meter
@property(nonatomic,assign)NSInteger remainDist;                // 剩余距离，单位：米 - remain distance, in meter
@property(nonatomic,assign)NSInteger remainTime;                // 剩余时间，单位：秒 - remain time, in second
@property(nonatomic,assign)double carRotAngle;                  // 车标旋转角度 - rotation angle for car
@property(nonatomic,assign)NSInteger carPosX;                   // 车标位置X - X-position for car
@property(nonatomic,assign)NSInteger carPosY;                   // 车标位置Y - Y-position for car
@property(nonatomic,copy)NSString* outRoadName;                 // 驶出道路名 - the next road name
@property(nonatomic,copy)NSString* straightIcon;                 // 直行图标
@property(nonatomic,assign)NSInteger imageWidth;                // 图片宽度，单位：像素 - width of image, in pixel
@property(nonatomic,assign)NSInteger imageHeight;               // 图片高度，单位：像素 - height of image, in pixel
@property(nonatomic,retain)UIImage* juncViewImage;              // 图片 - image of vector diagram enlargement

@end



/// 高速面板信息
@interface BNaviHighwayBoard : BNNaviMsgBase

@property (nonatomic,assign)  BNaviMessage_Action_Enum eAction;// 动作类型 - action type
@property (nonatomic,assign) NSUInteger exitRemainDist;        // 高速出口剩余距离
@property (nonatomic,retain) NSString *exitHighwayDirectName;  // 离开高速的方向名
@property (nonatomic,retain) NSString *exitHightwayNextRoadName;//离开高速进入的道路名
@property (nonatomic,retain) NSString *exitHighwayID;          // 离开高速的编号
@property (nonatomic,assign) NSUInteger tollGateTotalDist;     // 最近的收费站的剩余距离
@property (nonatomic,copy) NSString *tollGateName;             // 最近的收费站名称
@property (nonatomic,assign) NSUInteger saRemainDist;          // 最近的服务区剩余距离
@property (nonatomic,retain) NSString *highwaySAName;          // 最近的服务区名称
@property (nonatomic,assign) NSUInteger nextSARemainDist;      // 第二近的服务区剩余距离
@property (nonatomic,retain) NSString *nextHighwaySAName;      // 第二近的服务区名称
@property (nonatomic,retain) NSString *curHighwayRoadName;     // 当前高速路名
@property (nonatomic,assign) BOOL isLessGPMin;                 // 是否在距下一机动点3km以内，3km以内退出高速模式
@property (nonatomic, assign) BNaviManeuver_Kind_Enum exitHightwayTurnKind; //离开高速的转弯类型

@end


/// 高速入口信息
@interface BNaviInHighwayBoard : BNNaviMsgBase

@property (nonatomic,assign)  BNaviMessage_Action_Enum eAction; // 动作类型 - action type
@property (nonatomic,copy) NSString *highwayRoadName;           // 进入高速后路名
@property (nonatomic,assign) NSUInteger startDist;              // 进入高速总距离
@property (nonatomic,assign) NSUInteger remainDist;             // 进入高速后剩余距离

@end


/// 方向看板信息
@interface BNaviDirectionBoard : BNNaviMsgBase

@property (nonatomic,assign)  BNaviMessage_Action_Enum eAction; // 动作类型 - action type
@property (nonatomic,copy) NSString *directionName;             // 方向名
@property (nonatomic,copy) NSString *exitID;                    // 出口编号
@property (nonatomic,assign) NSUInteger startDist;              // 总距离
@property (nonatomic,assign) NSUInteger remainDist;             // 剩余距离
@property (nonatomic,assign) NSUInteger addDist;                // 积算距离

@end


/// 车点位置信息
@interface BNaviCarPosition : NSObject

@property(nonatomic,assign)double carPosX;          // 车标位置：x坐标 wgs84 - X-position in wgs84
@property(nonatomic,assign)double carPosY;          // 车标位置，y坐标 wgs84 - y-position in wgs84
@property(nonatomic,assign)double carRotateAngle;   // 车头与正北方向的夹角，单位：度 - angle between the direction of car and the due north, in degree
@property(nonatomic,assign)double carSpeed;         // 车标速度
@end

@interface BNaviRoadConditionItem : NSObject
///当前路况相对路线起点的距离 单位是 米 。
@property(nonatomic,assign)int startPointToCurItemDistance;
/// 路况类型
@property(nonatomic,assign)BNaviRoadCondition_Type_Enum eRoadConditionType;
@end

///导航中路况数据
@interface BNaviRoadConditionModel : NSObject
///每个元素是BNaviRoadConditionItem类型
@property (nonatomic, copy) NSArray<BNaviRoadConditionItem *> *roadConditionArray;

@end

///信号展示状态类型
typedef NS_ENUM(NSUInteger, BNaviSignalModelState) {
    BNaviSignalModelState_Tunnel,               // 在隧道
    BNaviSignalModelState_Underground,        // 在地库
    BNaviSignalModelState_Weak,                 // 信号弱
    BNaviSignalModelState_Medium,               // 信号中
    BNaviSignalModelState_Strong,               // 信号强
    BNaviSignalModelState_BDNotHighPrecision,   // 北斗非高精定位
    BNaviSignalModelState_BDHighPrecision,      // 北斗高精定位
};


@interface BNaviSignalModel : NSObject
///信号文案
@property (nonatomic, copy) NSString *siginalText;
///信号图片名称
@property (nonatomic, copy) NSString *siginalImgName;
///信号类型
@property (nonatomic, assign) BNaviSignalModelState state;

@end

/// 地图刷新操作相关的消息
@interface BNaviMapRefreshInfo : BNNaviMsgBase

@property(nonatomic,assign)BNaviMapRefresh_Type_Enum eMapRefreshType; // 地图刷新消息, type of message for map refresh

@property(nonatomic,retain)BNaviCarPosition* carPosInfo;            // 车标位置信息, information for car position

@property(nonatomic,retain)NSArray* roadCondition;//路况数组，它的每一个元素是 BNaviRoadConditionItem 类型

@end


/// 经过途经点的消息
@interface BNaviPassViaPointInfo : BNNaviMsgBase

@property(nonatomic,assign) int enType;
//viaIndex 途经点的序号，第一途经点序号为0（在路线节点里序号为1）
//如算路节点如下:[起点、途径点0、途径点1、途径点2、终点]。viaIndex=0。代表是途径点0
@property(nonatomic,assign) int viaIndex;

@end



/// 车道线信息
@interface BNaviLaneInfo : BNNaviMsgBase

@property (nonatomic, assign) BNaviMessage_Action_Enum eAction;

@end




/// 车速信息
@interface BNKMNaviSpeed : NSObject

@property (nonatomic, assign) int speed; // 单位km/h

@end


@interface BNIntervalSpeedModel : NSObject

/// 限速区域长度  单位：m
@property (nonatomic, assign) NSInteger intervalLength;
/// 限速区域长度 转化 Model
@property (nonatomic, strong) BNaviDistanceDescriptionModel *intervalLengthModel;

/// 当前区域 限速 单位：km/h
@property (nonatomic, assign) NSInteger limitSpeed;

/// 限速区域平均速度 单位：km/h
@property (nonatomic, assign) NSInteger limitAverageSpeed;

///限速区域剩余距离 单位 m
@property (nonatomic, assign) NSInteger limitAreaRemainDist;
/// 限速区域剩余距离 转化 Model
@property (nonatomic, strong) BNaviDistanceDescriptionModel *limitAreaRemainDistModel;
//区间测速 状态
@property (nonatomic, assign) BNIntervalSpeedModelState state;

@end


/// 货车限行消息结构体
@interface BNaviTruckTrafficSignInfo : BNNaviMsgBase
//限行，限重等枚举
@property(nonatomic) BNaviTruckTrafficSign trafficSignType;
//剩余距离
@property(nonatomic) NSInteger remainDistance;

@end


/// BNaviMessageHelper工具类
@interface BNaviMessageHelper : NSObject

/**
 *  获取路线详情项转向类型描述
 */
+ (NSString *)typeNameForManeuverKind:(BNaviManeuver_Kind_Enum)type;

@end
/**
 *  主辅路高架桥相关的消息
 */
@interface BNaviMainSlaveViaductInfo : BNNaviMsgBase
@property(nonatomic,assign)BN_MAB_VIEW_TYPE nChangeType; 
@end
/**
 *  主辅路高架桥切换回调
 */
@interface BNaviMainSlaveViaductMsg : BNNaviMsgBase
/// 是否切换成功
@property(nonatomic,assign)BOOL isSuccess;

@end

/**
 *  高速面板内容
 */
@interface BNaviHighwayContentModel : NSObject
///高速面板类型
@property (nonatomic, assign) BNaviHighwayInfoType highwayInfoType;
///服务区名称
@property (nonatomic, copy) NSString *name;
///距离 单位 m
@property (nonatomic, assign) NSUInteger remainDist;
///服务区 icon 类型  BNaviHighwayInfoDetailType
@property (nonatomic, copy) NSArray<NSNumber *> *typeArray;
///icon 图片名称
@property (nonatomic, copy) NSArray<NSString *> *typeIconStrArray;
/// 距离 转化 Model
@property (nonatomic, strong) BNaviDistanceDescriptionModel *disModel;

@end
/**
 *  高速面板
 */
@interface BNaviHighwayPanelModel : NSObject
@property (nonatomic, strong)  BNaviHighwayContentModel *topModel;
@property (nonatomic, strong)  BNaviHighwayContentModel *bottomModel;
@property (nonatomic, assign)  BNaviMessage_Action_Enum eAction; 
@end



