//
//  BNNaviCoreLogicManagerProtocol.h
//  BNOpenCommonKit
//
//  Created by chenxintao01 on 2024/4/25.
//  Copyright © 2024 Chen,Xintao. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "BNCommonDef.h"
NS_ASSUME_NONNULL_BEGIN
typedef NS_ENUM(NSUInteger, BNNaviCoreLogicErrorType) {
    BNNaviCoreLogicErrorType_NaviAlreadyOpen,           ///已开启导航不能重复开启。
    BNNaviCoreLogicErrorType_NaviTypeMismatch,          ///导航类型不匹配
    BNNaviCoreLogicErrorType_Unauthorized,              ///未通过授权，暂不能使用百度导航SDK。
};


@protocol BNNaviCoreLogicManagerProtocol <NSObject>

/// 返回是否开启了导航
- (BOOL)naviIsStart;

/// 开始导航
/// - Parameters:
///   - naviType: 导航类型
///   - extParam: 预留字段，目前可以传nil
/// - Return: 为空则成功开始导航。
/// 错误类型 code：返回的错误类型 BNNaviCoreLogicErrorType。domain: 错误原因描述
- (NSError *)startNavi:(BN_NaviType)naviType extParam:(NSDictionary * _Nullable)extParam;

/// 结束导航
/// - Parameters:
///   - naviType: 导航类型
///   - extParam: 预留字段，目前可以传nil
/// - Return:  为空则成功结束导航。
/// 错误类型 code：返回的错误类型 BNNaviCoreLogicErrorType。domain: 错误原因描述

- (NSError *)stopNavi:(BN_NaviType)naviType extParam:(NSDictionary * _Nullable)extParam;

@end

NS_ASSUME_NONNULL_END
