//
//  BNMultiMapManagerProtocol.h
//  BNOpenCommonKit
//
//  Created by v_lisisi on 2023-11-24.
//  Copyright © 2023 Chen,Xintao. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <BaiduMapAPI_Map/BMKMapView.h>
NS_ASSUME_NONNULL_BEGIN

@protocol BNKMapViewDelegate <NSObject>

/// 配置地图2D模式车标的偏移量
/// 坐标原点为0,0。
/// x表示横坐标的偏移量，负数往左边移动，正数往右边移动
/// y表示纵坐标的偏移量，负数往下边移动，正数往上边移动
- (CGPoint)carOffsetFor2DMode;

/// 配置地图3D模式车标的偏移量
/// 坐标原点为0,0。
/// x表示横坐标的偏移量，负数往左边移动，正数往右边移动
/// y表示纵坐标的偏移量，负数往下边移动，正数往上边移动
- (CGPoint)carOffsetFor3DMode;


@end
typedef enum BNMapCarElementType {
    BNMapCarElementType_Camera,         // 电子眼
    BNMapCarElementType_EnterRoad,      // 进入路名
    BNMapCarElementType_Jam,            // 拥堵
    BNMapCarElementType_Route,          // 路线
    BNMapCarElementType_TrafficSign,    // 安全提示
    BNMapCarElementType_Ugc,            // UGC外露
    BNMapCarElementType_Guide,          // 机动点诱导
    BNMapCarElementType_RouteDesc,      // 路线可理解性
    BNMapCarElementType_DestNode,       // 终点
    BNMapCarElementType_TrafficLight,   // 红绿灯标签
    BNMapCarElementType_RouteConditionForecast,     // 路况预测标签
} BNMapCarElementType;

typedef NS_ENUM(NSInteger, BNMIDIYImageType) {
    BNMI_DIYImage_CarLogo = 0,    //车标
    BNMI_DIYImage_StartPoint = 1, //起点
    BNMI_DIYImage_EndPoint = 2,   //终点
    BNMI_DIYImage_WayPoint,       //途径点
};
typedef NS_ENUM(NSInteger, BNMIMapNaviMode) {
    BNMIMapNaviModeNormal,        //导航
    BNMIMapNaviModeRoute,         //驾车路线页
};
@interface BNKMapView : BMKMapView

@property (nonatomic, weak) id<BNKMapViewDelegate> naviMapViewDelegate;

/// 添加自定义UI碰撞，添加后，路线全览时会路线的展示区域不显示在frame的范围内
/// - Parameter 
///   - frame: 自定义碰撞的frame
- (void)addUIViewBound:(CGRect)frame;

/// 设置路线全览展示区域
/// - Parameter 
/// - insets: 路线全览展示区域距离MapView四周的边距
- (void)setRouteShowRect:(UIEdgeInsets)insets;

/// 全览
/// - Parameter 
///   - viewAll: 是否全缆
- (void)setViewAllMode:(BOOL)viewAll;

///设置地图为3D模式
- (void)set3DMode;

/// 设置地图为2D模式
- (void)set2DMode;

/// 显示路况
/// - Parameter 
///   - show: 为YES，展示路况，为NO，隐藏路况
- (void)showRoadCondition:(BOOL)show;

/// 隐藏路线动态标签，默认全部展示
/// 注意：这个接口不会记住之前传入的隐藏标签类型。
/// 比如第一次隐藏 以下标签：@[@(BNMapCarElementType_Camera), @(BNMapCarElementType_EnterRoad), @(BNMapCarElementType_Jam)];
/// 后续又需要显示@(BNMapCarElementType_Camera) ， 则需要再次传入@[ @(BNMapCarElementType_EnterRoad), @(BNMapCarElementType_Jam)];
/// - Parameter 
///   - types: 隐藏的标签类型数组，数组元素为BNMapCarElementType类型，封装为NSNumber对象
- (void)hideMapCarElement:(NSArray <NSNumber *> *)types;

/// 清除自定义icon
/// - Parameter 
///   - type: 自定义icon类型
-(void)clearDIYIcon:(BNMIDIYImageType)type;

/// 设置自定义icon
/// - Parameters
///   - img: 车标图片
///   - imageType: 车标类型
- (void)setDIYIcon:(UIImage *)img type:(BNMIDIYImageType)imageType;

/// 设置自定义icon 显示 隐藏
/// - Parameters:
///   - isShow: YES 是显示 NO隐藏
///   - imageType: 车标类型
- (void)setDIYImageShow:(BOOL)isShow type:(BNMIDIYImageType)imageType;

/// 设置途径点icon
/// - Parameters
///   - images:  数组中存放的是UIimage
///   - indexes: 途径点下标
- (void)setWayPointCustomImages:(NSArray<UIImage *> *)images indexes:(NSArray *)indexes;

/// 是否支持车道级，app需要具备车道级权限调用才生效。
/// 开启车道级后，当进入车道级路段后会自动设置当前多实例为3D模式。
/// - Parameters
///   - supportLane： YES 开启车道级。 NO 不开启车道级。 如果有车道级权限，默认开启
- (void)setSupportLane:(BOOL)supportLane;

/// 白天黑夜模式
/// - Parameter 
///   - isNight: YES 代表黑夜。NO代表白天 。 默认白天模式*/
- (void)setNight:(BOOL)isNight;

///销毁多实例
- (void)destroyController;

/// 多实例地图模式
/// - Parameter
///   - BNMIMapNaviMode:
- (void)setNaviMode:(BNMIMapNaviMode)naviMode;
///车标大小 范围0.0～1.0.默认值:1。
- (void)setCarIconScale:(CGFloat)scale;
///罗盘 大小 范围0.0～1.0.默认值:1。
- (void)setCompassScale:(CGFloat)scale;
///车道级 大小 范围0.0～1.0.默认值:1。
- (void)setHDModelCarScale:(CGFloat)scale;

@end


@protocol BNMultiMapManagerProtocol <NSObject>


/// 创建多实例
/// - Parameters:
///  - tag: 多实例标记. 不同MapView实例 需要使用不一样的tag，比如tag可以使用整数进行递增。
///  - frame: 创建的MapView的frame
- (BNKMapView *)createNaviMapViewWithTag:(NSString *)tag withFrame:(CGRect)frame;


@end


NS_ASSUME_NONNULL_END
