//
//  BNMotorInfoModel.h
//  BNOpenCommonKit
//
//  Created by chenxintao on 2021/9/24.
//  Copyright © 2021 Chen,Xintao. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, BNMotorPlateType){
    BNMotorPlateType_Invalid = 0,  //无效
    BNMotorPlateType_Yellow = 1, //黄牌
    BNMotorPlateType_Blue = 2, //蓝牌
};

typedef NS_ENUM(NSInteger, BNMotorPowerType){
    BNMotorPowerType_Oil = 0,  //油
    BNMotorPowerType_Electric = 1, //电
};
///摩托车model
@interface BNMotorInfoModel : NSObject

@property (copy, nonatomic) NSString *plate; //车牌号码，粤BH4533

@property (assign, nonatomic) BNMotorPlateType plateType; //车牌类型

@property (assign, nonatomic) NSInteger displacement; //排放量

@property (assign, nonatomic) BNMotorPowerType powerType; //能耗类型

@end

NS_ASSUME_NONNULL_END
