//
//  BNMapOverlayManagerProtocol.h
//  baiduNaviSDK
//
//  Created by chenxintao on 2017/11/20.
//  Copyright © 2017年 baidu. All rights reserved.
//

#ifndef BNMapOverlayManagerProtocol_h
#define BNMapOverlayManagerProtocol_h
//note:自定义图层相关
#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "BNRoutePlanModel.h"

typedef NS_ENUM(NSInteger, BN_DIYImageType) {
    BN_DIYImage_CarLogo = 0,    //车标
    BN_DIYImage_StartPoint = 1, //起点
    BN_DIYImage_EndPoint = 2,   //终点
    BN_DIYImage_3DCar = 3,      //3D车标
    BN_DIYImage_WayPoint = 4,      //途经点
} ;

/**
 * @brief 自定义图层类
 */
@interface BNaviMapItemData : NSObject

@property (strong, nonatomic) UIImage* image;

@property (strong, nonatomic) BNPosition* pos;

@property (assign, nonatomic) CGFloat xAlign;

@property (assign, nonatomic) CGFloat yAlign;


@end

/**
 * @brief 自定义图层管理接口，自定义icon接口
 */
@protocol BNMapOverlayProtocol

/**
 设置自定义3D类型图片
 
 @param images 设置的图片数组(以正西方向为第一张图片）
 @param type 类型
 */
- (void)setDIY3DImageToMap:(NSArray *)images
                 imageType:(BN_DIYImageType)type;

/**
 设置自定义类型图片

 @param image 设置的图片
 @param type 类型
 */
- (void)setDIYImageToMap:(UIImage*)image
               imageType:(BN_DIYImageType)type;

/// 自定义途经点icon
/// @param images 图片
/// @param indexes 图片索引
/// @note 途经点对应的图片为indexes数组中的存储的图片索引，例如：images有2张图片，第3个途经点的索引是0，则该途经点的icon为images[0]中的图片
- (void)setWayPointCustomImages:(NSArray *)images indexes:(NSArray *)indexes;


/**
 清除自定义类型

 @param type 类型
 */
- (void)clearDIYImage:(BN_DIYImageType)type;


/**
 设置自定义图片隐藏和显示

 @param hidden 是否隐藏
 @param type 自定义类型
 */
- (void)setDIYImageHidden:(BOOL)hidden
                imageType:(BN_DIYImageType)type;

/**
 设置货车限行/限高/限重/限宽icon展示

 @param hidden 是否隐藏,默认隐藏
 */
- (void)setTruckLimitTypeIconHidden:(BOOL)hidden;

@end

#endif /* BNMapOverlayManagerProtocol_h */
