//
//  BNLightNaviManagerProtocol.h
//  BNLightNaviKit
//
//  Created by chenxintao on 2021/5/19.
//

#ifndef BNLightNaviManagerProtocol_h
#define BNLightNaviManagerProtocol_h
#import <Foundation/Foundation.h>
#import "BNLightRoutesModel.h"

@class BNCarRouteModel;
@class BNaviSimpleGuideInfo;
@class BNaviRemainTrafficlightsInfo;
@class BNaviRemainInfo;
@class BNaviStatusInfo;
@protocol BNLightNaviManagerDelegate;

/// 轻导航模块接口
@protocol BNLightNaviManagerProtocol <NSObject>

/// BNLightNaviManager的delegate，接收事件回调
@property (weak, nonatomic) id<BNLightNaviManagerDelegate> delegate;

/// 自动回车位的间隔，单位为秒，默认为60秒
@property (nonatomic, assign) NSInteger autoReturnCarDuration;


/// 轻导航中到达终点后是否自动删除路线，默认是YES
@property (nonatomic, assign) BOOL deleteRouteWhenArriveDestination;

/// 路线全览
/// @param insets 路线全览区域在mapview上的insets
- (void)zoomToSpan:(UIEdgeInsets)insets;

/// 开始轻导航
- (void)startLightNavi;

/// 结束轻导航
- (void)stopLightNavi;

/// 从轻导航切换到专业导航（包括从驾车轻导航切换到驾车专业导航，货车轻导航切换到货车专业导航）
/// @param presentVC  present专业导航页面的ViewController
/// @param naviType 切换到哪种类型的专业导航，从货车轻导航切换到货车专业导航，传@"Truck"，从驾车轻导航切换到驾车专业导航，传@"Car"
- (BOOL)switchToRealNav:(UIViewController*)presentVC withNaviType:(NSString *)naviType;

/// 轻导航底图即将显示，在viewWillAppear中调用
/// @param parentView mapView的父view
- (void)viewWillAppear:(UIView*)parentView;

/// 轻导航底图即将消失，在viewWillDisAppear中调用
/// @param parentView mapView的父view
- (void)viewWillDisAppear:(UIView*)parentView;


/// 根据返回的3tab数据序号选路
/// @param routeIndex 3tab数据BNLightRoutesModel中routesInfo数组的下标
- (void)selectRouteWithRouteDetailIndex:(NSInteger)routeIndex;


/// 获取当前3tab数据哪个高亮
- (NSInteger)getSelecRouteDetailIndex;

@end


/// 轻导航模块回调
@protocol BNLightNaviManagerDelegate <NSObject>

/// sdk内部偏航时进行路线全览，会回调外部这个接口，如果没有实现，使用上一次调用的zoomToSpan:的参数，如果没有调用过zoomToSpan:，则为{0,0,0,0}
- (UIEdgeInsets)zoomToSpanInsets;

/// 退出导航的回调
/// @param params 预留参数，目前传nil
- (void)onHandleExitNavi:(NSDictionary *)params;

/// 主线变化后的回调
/// @param carRouteModel 偏航成功后的路线数据，可以从carRouteModel.tipsInfoGroup中获取限行信息
/// 可以通过
-(void)onHandleDrivingRouteChange:(BNCarRouteModel *)carRouteModel;

/// 剩余时间、距离更新的回调
/// @param remainInfo 剩余时间、距离的model
-(void)onHandleRemainInfo:(BNaviRemainInfo *)remainInfo;

/// 诱导信息隐藏的回调
- (void)onHandleSimpleGuideInfoHide;

/// 诱导信息显示/更新的回调
/// @param simpleGuideInfo 需要显示/更新的诱导信息
-(void)onHandleSimpleGuideInfo:(BNaviSimpleGuideInfo*)simpleGuideInfo;

/// 导航中各种状态
/// @param naviStatusInfo  开始导航 导航结束
- (void)onHandleNaviStatusChange:(BNaviStatusInfo*)naviStatusInfo;


/// 轻导航3tab数据变化回调
/// @param model 数据model
- (void)onHandleRouteDetailChange:(BNLightRoutesModel *)model;


/// 点击底图路线后的回调
/// @param routeDetailIndex BNLightRoutesModel中序号变化的回调
- (void)onHandleClickRoute:(NSInteger)routeDetailIndex;


/// 从导航中切换回轻导航失败的回调，开发者需要重新算路并开始轻导航
- (void)onHandleSwitchToLightNaviFail;

///专业导航中暴露出来的导航中的View
- (void)onHandleProfessionalNaviViewDidLoad:(UIView*)naviView;
@end

#endif /* BNLightNaviManagerProtocol_h */
