//
//  BNGuideViewModel.h
//  BNGuideViewModule
//
//  Created by Huang,Anda on 2020/12/19.
//

#import <Foundation/Foundation.h>
#import "BNCommonDef.h"
/// 默认诱导主面板状态
typedef NS_ENUM(NSInteger, BNGuideDefaultViewState) {
    BNGuideDefaultViewStateNormal,      // 普通机动点
    BNGuideDefaultViewStateHighway,      // 高速模式
    BNGuideDefaultViewStateFuzzy        // 起点命中模糊诱导
};

// 道路类型
typedef NS_ENUM(NSUInteger, BNGuideViewRoadType) {
    BNGuideViewRoadNormalType = 0,
    BNGuideViewRoadStraightType,
    BNGuideViewRoadVDRType
};

@class BNGuideViewMainModel;
@class BNGuideViewAssistModel;
@class BNGuideViewNextTurnContentAssistModel;
NS_ASSUME_NONNULL_BEGIN
#pragma mark - 组合
/**
 组合Model
 */
@interface BNGuideViewCombinationModel : NSObject

@property (nonatomic, strong) BNGuideViewMainModel *mainModel;

@property (nonatomic, strong) BNGuideViewAssistModel *assistModel;

@end
#pragma mark - 主诱导面板
/**
 主诱导面板Model
 */
@interface BNGuideViewMainModel : NSObject
/// 绑定的主诱导面板类型
@property (nonatomic, copy) NSString *mainViewClass;
/**
 6种模版
 1. icon+XXX公里+进入+XXX路
 2. icon+现在+进入+XXX路
 3. icon+XXX公里+出口+驶往+XXX方向
 4. icon+XXX公里+出口+进入+XXX路
 5. icon+沿+XXX路+XXX公里
 6. icon+XXX公里+出口+驶出+XXX主路
 */
/// 转向标icon
@property (nonatomic, copy) NSString *turnIconStr;
/// 衔接词（进入、驶往、驶出）
@property (nonatomic, copy) NSString *cohesiveWord;
/// 出口（出口+id）
@property (nonatomic, copy) NSString *exitInfo;
/// 填充词（XXX方向、XXX路、XXX主路）
@property (nonatomic, copy) NSString *supplementWord;
/// 辅助词（方向、主路）
@property (nonatomic, copy) NSString *assistWord;

/// 诱导转向类型
@property (nonatomic, assign) BNaviManeuver_Kind_Enum curTurnKind;

#pragma mark - 机动点剩余距离相关属性
/// 机动点剩余距离（XXX），原始数据，单位是 米，比如300
@property (nonatomic, assign) NSInteger remainDistNum;

/*
remainDistKMValue和remainDistMValue只能是一个有效或者两个都无效，无效值为-1，如果两个都无效时，表示距离不展示具体数字，比如展示为【现在】，可以使用remainDistDescription字段展示
如果距离需要展示为公里，使用remainDistKMValue的值，如果需要展示为米，使用remainDistMValue的值
 */
/// 机动点剩余距离展示为公里的数值，单位为公里，比如3.4，-1表示无效值
@property (nonatomic, assign) CGFloat remainDistKMValue;
/// 机动点剩余距离展示为米的数值，单位为米，比如10，-1表示无效值
@property (nonatomic, assign) CGFloat remainDistMValue;
///机动点剩余距离UI上的整体展示，比如4.7公里、现在
@property (nonatomic, copy) NSString *remainDistDescription;

/*
 remainDistNumStr和remainDistUnitStr为UI数据，remainDistUnitStr为具体数值，也可能为非具体数值的文案，比如【现在】
 remainDistNumStr为具体数值，remainDistUnitStr为数值的单位，比如remainDistNumStr为100，remainDistUnitStr为米
 remainDistNumStr为非具体数值时，remainDistUnitStr为空
 */
/// 机动点剩余距离（XXX、现在）
@property (nonatomic, copy) NSString *remainDistNumStr;
/// 剩余距离单位（公里、米）
@property (nonatomic, copy) NSString *remainDistUnitStr;

@end

#pragma mark 无出口的诱导面板
/**
 不带出口的主面板Model基类
 */
@interface BNGuideViewWithoutExitMainModel : BNGuideViewMainModel
/// 状态
@property (nonatomic, assign) BNGuideDefaultViewState state;
/// 是否是车标自由态
@property (nonatomic, assign) BOOL isCarFree;
/// 是否需要loading
@property (nonatomic, assign) BOOL isLoading;
/// loading文案
@property (nonatomic, copy) NSString *loadingText;
/// 道路类型
@property (nonatomic, assign) BNGuideViewRoadType roadType;
/// fuzzy文案
@property (nonatomic, copy) NSString *fuzzyText;

@end

/**
 默认诱导主面板Model
 */
@interface BNGuideViewDefaultMainModel : BNGuideViewWithoutExitMainModel

@end

#pragma mark 有出口的诱导面板
/**
 有出口的诱导主面板Model
 */
@interface BNGuideViewExitMainModel : BNGuideViewMainModel

@end


#pragma mark - 辅助面板
/**
 辅助面板Model
 */
@interface BNGuideViewAssistModel : NSObject

@end

/**
 随后辅助面板Model
 */
@interface BNGuideViewNextTurnAssistModel : BNGuideViewAssistModel
/// 是否是高快速出口，是的话要变绿色，不是则为黑色
@property (nonatomic, assign) BOOL highFastExitMode;

@property (nonatomic, strong) BNGuideViewNextTurnContentAssistModel *contentAssistModel;

@end

/**
 None辅助面板
 */
@interface BNGuideViewNoneAssistModel : BNGuideViewAssistModel

@end

#pragma mark - 随后面板内容Model
/**
 随后Style内容
 */
@interface BNGuideViewNextTurnContentAssistModel : NSObject
/**
 随后有6种模版
 1. 随后+icon+驶往+XXX方向
 2. 随后+icon+进入+XXX路
 3. 随后+icon+到达+目的地
 4. 驶往+XXX+方向
 5. 进入+XXX
 6. 到达+目的地
 
 首先判断是否有方向数据，有方向则为第一种
 没有方向数据，则判断icon是否是到达目的地icon，是的话，则为第三种
 否则为第二种，第二种可能没有icon
 */
/// 写死的“随后”
@property (nonatomic, copy) NSString *nextTurnStr;
/// icon
@property (nonatomic, copy) NSString *nextTurnIconStr;
/// 衔接词（驶往、进入、到达）
@property (nonatomic, copy) NSString *cohesiveWord;
/// 填充词（XXX方向、XXX路、目的地）
@property (nonatomic, copy) NSString *supplementWord;
/// 辅助词（方向、主路）
@property (nonatomic, copy) NSString *assistWord;
///诱导转向类型
@property (nonatomic, assign) BNaviManeuver_Kind_Enum curTurnKind;

@end


NS_ASSUME_NONNULL_END
