//
//  BNCustomYellowTips.h
//  BNDriverPageKit
//
//  Created by v_lisisi on 2020/6/3.
//  Copyright © 2020 Chen,Xintao. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN
/// 小黄条model
@interface BNCustomYellowTips : NSObject
@property (nonatomic, copy)     NSString* title;
@property (nonatomic, copy)     NSString* subTitle;
@property (nonatomic, copy)     NSString* assistInfo;           //辅助信息，tip_id=3（1为同城，2为跨城）；tip_id=4（跳转url）
@property (nonatomic, strong) NSString* styleText;//样式文本
@property (nonatomic, assign)   NSInteger tipsId;               //小黄条唯一标识ID
@property (nonatomic, assign)   NSInteger iconId;               //云端干预特定图片的id序列  Icon ID
@property (nonatomic, assign)   NSInteger backgroundColorId;    //背景颜色id序列
@property (nonatomic, strong)   NSMutableArray* buttonArr;//按钮数组，类型为BMYellowTipsButtonInfo
@property (nonatomic, strong)   NSString* restrictionId;         //可穿行id

@property (nonatomic)   BOOL jumpFlag;         //是否支持跳转
@property (nonatomic)   BOOL panelFlag;         //是否支持弹出面板
@property (nonatomic, strong)   NSString* eventId;         //事件id
@property (nonatomic)   NSInteger eventType;         //事件类型
@property (nonatomic)   NSInteger roadNo;           //路线编号
@end

NS_ASSUME_NONNULL_END
