//
//  BNCarRouteData.h
//  BNDriverPageKit
//
//  Created by linbiao on 2019/5/16.
//  Copyright © 2019年 Chen,Xintao. All rights reserved.
//

#import <Foundation/Foundation.h>

@class BNCarRouteNode;
@class BNYellowTipsInfoGroup;
@class BNPosition;
@class BNGCJPosition;

NS_ASSUME_NONNULL_BEGIN

/// 多路线总信息
@interface BNCarRouteModel : NSObject

/// 多路线，NSMutableArray的内容为BNCarOneRouteModel
@property (nonatomic, strong) NSMutableArray *carRoutes;

@end


/// 单独的一条路线信息
@interface BNCarOneRouteModel : NSObject

/// 默认线路小面板显示内容
@property (nonatomic, strong) NSString *routeLabelName;

/// 总路程（米)
@property (nonatomic, assign) NSInteger distance;

/// 预计的行驶时间 ,秒
@property (nonatomic, assign) NSInteger time;

/// 红绿灯个数
@property (nonatomic, assign) NSInteger lightNum;

/// 高速收费
@property (nonatomic, assign) NSInteger toll;

/// 路段列表,NSMutableArray的内容为BNCarRouteStepModel
@property (nonatomic, strong) NSMutableArray *stepList;

/// 起点
@property (nonatomic, strong) BNCarRouteNode *startPoint;

/// 途经点 BNCarRouteNode
@property (nonatomic, strong) NSArray * viaPointArray;

/// 终点
@property (nonatomic, strong) BNCarRouteNode *endPoint;

/// 小黄条集合，可能为空
@property (nonatomic, strong) BNYellowTipsInfoGroup *tipsInfoGroup;
/// 返回当前路线信息所有坐标点
@property (nonatomic, copy) NSArray<BNGCJPosition*> *coordinates;
///途径市 @[@{@"cityname":@"北京",@"citycode":@"243"},......]
@property (nonatomic, copy) NSArray<NSDictionary*> *passCityArray;

@end

typedef NS_ENUM(NSInteger, BNCarRouteRoadConditonType)
{
    BNCarRouteRoadConditonType_Type_Invalid         = 0,//无效值
    BNCarRouteRoadConditonType_Type_Straightway     = 1,//顺畅
    BNCarRouteRoadConditonType_Type_Slow            = 2,//缓慢
    BNCarRouteRoadConditonType_Type_Obstruction     = 3,//拥堵
    BNCarRouteRoadConditonType_Type_VeryObstruction = 4//非常拥堵
};


/// 路段信息
@interface BNCarRouteStepModel : NSObject
/// 返回当前路线信息所有坐标点
@property (nonatomic, copy) NSArray<BNGCJPosition*> *coordinates;
/// 以米为单位的路线长度
@property (nonatomic, assign) NSInteger distance;

/// 以秒为单位的路线花费时间
@property (nonatomic, assign) NSInteger time;

/// 路段的提示语，按照html格式组织
@property (nonatomic, copy) NSString *linkFormatTip;

/// 该路段导航转向类型
@property (nonatomic, assign) NSInteger turn;

@property (nonatomic) BNPosition *startPoint;

@property (nonatomic) BNPosition *endPoint;



/*!
 取路况数据需要使用到 coordinates、 pointCountArrayOfSameRC、roadConditonTypeArray。
 具体使用描述如下
 路况区间数量
 如：
 coordinates = @[BNGCJPosition,BNGCJPosition,BNGCJPosition....];
 pointCountArrayOfSameRC = @[@(100),@(24),@(56)];
 roadConditonTypeArray = @[@(BNCarRouteRoadConditonType_Type_Straightway),
            @(BNCarRouteRoadConditonType_Type_Slow),
            @(BNCarRouteRoadConditonType_Type_Obstruction)
 ];
 分别有3段不一样的路况数据。
 @(100)代表在 coordinates 中 取0....100之间的数据，这段坐标数据对应对路况类型roadConditonTypeArray[0]。
 @(24)代表在 coordinates 中  取100...(100+24)之间的数据，这段坐标数据对应对路况类型roadConditonTypeArray[1]。
 @(56)代表在 coordinates 中  取(100+24)...(100+24+56)之间的数据，这段坐标数据对应对路况类型roadConditonTypeArray[2]。
 
 
 特例：如pointCountArrayOfSameRC 只有一个数据而且数据是0.那么对应coordinates。就取得第一个
 */
@property (nonatomic, copy) NSArray<NSNumber*>  *pointCountArrayOfSameRC;

/*!
 @property
 @abstract 描述路况信息 路况的@[@(BNCarRouteRoadConditonType),@(BNCarRouteRoadConditonType)]
 */
@property (nonatomic, copy) NSArray<NSNumber*>  *roadConditonTypeArray;
@end



/// 节点
@interface BNCarRouteNode : NSObject

/// 节点名称
@property (nonatomic, copy) NSString *name;

@end


/// 小黄条集合
@interface BNYellowTipsInfoGroup : NSObject

/// 小黄条集合，NSMutableArray的内容为BNYellowTipsInfo
@property (nonatomic, strong) NSMutableArray *tipsInfoArray;

@end


/// 单个小黄条数据结构
@interface BNYellowTipsInfo : NSObject

/// 小黄条标题
@property (nonatomic, copy) NSString *title;

@end


/// 工具类
@interface BNCarRouteDataUtil : NSObject

+ (NSString *)typeIconNameOfEnum:(NSInteger)type;

@end

NS_ASSUME_NONNULL_END
