//
//  BMTruckInfoModel.h
//  basicmap
//
//  Created by Lin,Biao on 2019/9/11.
//  Copyright © 2019 baidu. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, BMTruckType) {
    BMTruckTypeUnknown = 0,
    BMTruckTypeMicro,       // 微型货车
    BMTruckTypeLight,       // 轻型货车
    BMTruckTypeMedium,      // 中型货车
    BMTruckTypeHeavy,       // 重型货车
    BMTruckTypeTow,         // 拖挂车
    BMTruckTypeSpecial,     // 专用货车
    BMTruckTypeOffRoad,     // 越野货车
};

typedef NS_ENUM(NSInteger, BMTruckPowerType) {
    BMTruckPowerTypeUnknown = 0,
    BMTruckPowerTypeGasoline,   // 汽油车
    BMTruckPowerTypeDiesel,     // 柴油车
    BMTruckPowerTypeEletric,    // 电车
    BMTruckPowerTypeMixed,      // 混动车
};

typedef NS_ENUM(NSInteger, BNTruckPlateColor) {
    BNTruckPlateColorUnknown = 0,
    BNTruckPlateColorYellow,    // 黄牌
    BNTruckPlateColorBlue,      // 蓝牌
    BNTruckPlateColorGreen,     // 绿牌
    BNTruckPlateColorBlack,     // 黑牌
    BNTruckPlateColorWhite,     // 白牌
};
typedef NS_ENUM(NSInteger, BNTruckCarType) {
    BNTruckCarTypeCommon = 0,  ///普通车
    BNTruckCarTypeEnegry,    // 新能源
};

/// 货车model
@interface BMTruckInfoModel : NSObject
@property (nonatomic) BNTruckCarType truckCarType;            // 货车类型的车辆牌照的类型
@property (nonatomic) BMTruckType truckType;            // 货车类型
@property (nonatomic) BMTruckPowerType powerType;       // 动力类型
@property (nonatomic) NSString *carNumber;              // 车牌号                  例如：京B88888
@property (nonatomic) NSInteger emission;               // 排放标准                例如：国五 emission = 5
@property (nonatomic) NSInteger oilCost;                // 百公里油耗 毫升 0~150L   例如：百公里耗油20升 oilCost = 20 * 1000
@property (nonatomic) CGFloat weight;                   // 车重单位kg 0~100吨    例如：1吨 weight = 1 * 1000
@property (nonatomic) CGFloat load;                     // 载重单位kg 0~100吨    例如：1吨 load = 1 * 1000
@property (nonatomic) CGFloat length;                   // 车长单位mm 0~25米     例如：1米 length = 1 * 1000
@property (nonatomic) CGFloat width;                    // 车宽单位mm 0~5米      例如：1米 width = 1 * 1000
@property (nonatomic) CGFloat height;                   // 车高单位mm 0~10米     例如：1米 height = 1 * 1000
@property (nonatomic) NSInteger axleNumber;             // 轴数                 例如 3轴 axleNumber = 3;
@property (nonatomic) CGFloat axleWeight;               // 轴重单位kg 0~100吨    例如：1吨 weight = 1 * 1000
@property (nonatomic) BNTruckPlateColor plateColor;     // 车牌颜色
@property (nonatomic,readonly) NSString *truckTypeText; // 货车类型描述

@end
/// 货车model
@interface BMCarInfoModel : NSObject
@property (nonatomic) BNTruckCarType truckCarType;            // 货车类型的车辆牌照的类型
@property (nonatomic) NSString *carNumber;              // 车牌号
@end
NS_ASSUME_NONNULL_END
