/*
 *  BMKSuggestionSearchOption.h
 *  BMapKit
 *
 *  Copyright 2014 Baidu Inc. All rights reserved.
 *
 */

#import <Foundation/Foundation.h>
#import <CoreLocation/CoreLocation.h>
#import <BaiduMapAPI_Base/BMKTypes.h>

/// sug检索信息类
@interface BMKSuggestionSearchOption : NSObject

/// 搜索关键字，必选
@property (nonatomic, copy) NSString *keyword;
/// 城市名，参数也可以传入citycode，必选
@property (nonatomic, copy) NSString *cityname;
/// 指定位置，可选，注：会影响关键字不在设置城市范围内时的检索结果，故不建议使用。
@property (nonatomic, assign) CLLocationCoordinate2D location;
/// 是否只返回指定城市检索结果（默认：NO）（提示：海外区域暂不支持设置cityLimit）
@property (nonatomic, assign) BOOL cityLimit;
/// 是否仅透出热词,默认：NO
@property (nonatomic, assign) BOOL hotword;
/// sug检索支持指定范围检索（过滤距离和图区范围 二选一）
/// 过滤距离大小，可选 。结合location使用。 单位：米
@property (nonatomic, assign) NSInteger filterDistance;
/// 地图图区的范围（左下角），可选
@property (nonatomic, assign) CLLocationCoordinate2D leftBottom;
/// 地图图区的范围（右上角），可选
@property (nonatomic, assign) CLLocationCoordinate2D rightTop;
/// 可选，参数输入的语言类型，默认 BMKInputLanguageTypeAuto；
@property (nonatomic, assign) BMKInputLanguageType inputLanguageType;
/// 可选。语言类型，默认中文。
@property (nonatomic, assign) BMKLanguageType languageType;
@end


