/*
 *  BMKBusLineSearchOption.h
 *  BMapKit
 *
 *  Copyright 2014 Baidu Inc. All rights reserved.
 *
 */

#import <Foundation/Foundation.h>
#import <BaiduMapAPI_Base/BMKTypes.h>

/// 公交线路检索信息类
@interface BMKBusLineSearchOption : NSObject
/// 可选。城市名
@property (nonatomic, copy) NSString *city;
/// 可选。城市id
@property (nonatomic, copy) NSString *cityId;
/// 公交线路的uid 注：从Sug检索或者POI城市检索中搜索公交线路,得到的结果中获取。
@property (nonatomic, copy) NSString *busLineUid;
/// 可选。起始站点uid
@property (nonatomic, copy) NSString *startUid;
/// 可选。终点站点uid
@property (nonatomic, copy) NSString *endUid;
/// 可选。结果输出语言类型，默认中文。
@property (nonatomic, assign) BMKLanguageType languageType;
@end

