//
//  BMKTextStyle.h
//  MapComponent
//
//  Created by zhaoxiangru on 2024/3/12.
//  Copyright © 2024 Baidu. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN
typedef enum : NSUInteger {
    BMKFontNormal,       /** 标准 */
    BMKFontBold,         /** 加粗 */
} BMKFontOption;

/// 文本样式
@interface BMKTextStyle : NSObject
/// 文本颜色，默认黑色
@property(nonatomic, strong) UIColor *textColor;
/// 字体样式，默认BMKFontNormal
@property(nonatomic, assign) BMKFontOption fontOption;
/// 字体大小，默认24
@property(nonatomic, assign) int fontSize;
/// 描边宽度，默认0
@property(nonatomic, assign) int borderWidth;
/// 描边颜色，默认白色
@property(nonatomic, strong) UIColor *borderColor;

@end

NS_ASSUME_NONNULL_END
