//
//  BMKTextPathMarker.h
//  MapComponent
//
//  Created by zhaoxiangru on 2024/3/11.
//  Copyright © 2024 Baidu. All rights reserved.
//

#import "BMKShape.h"
#import "BMKOverlay.h"
//#import "BMKRichView.h"
//#import "BMKBaseUIView.h"
#import "BMKMapAnimation.h"
#import "BMKCommonDef.h"
#import "BMKTextStyle.h"
NS_ASSUME_NONNULL_BEGIN

@interface BMKTextPathMarker : BMKMultiPoint <BMKOverlay>
{
@package
    BMKMapRect _boundingMapRect;
}
@property (nonatomic, strong) NSString *text;
@property (nonatomic, strong) BMKTextStyle *style;

/// 根据指定路名的路线信息坐标集合点生成路名对象
/// @param points  指定的直角坐标点数组
/// @param count  points数组中坐标点的个数
/// @return 新生成的路名对象
+ (nullable instancetype)textPathMarkerWithPoints:(BMKMapPoint *)points count:(NSUInteger)count;

/// 根据指定坐标点生成路名对象
/// @param coords 指定的经纬度坐标点数组
/// @param count coords数组中坐标点的个数
/// @return 新生成的路名对象
+ (nullable instancetype)textPathMarkerWithCoordinates:(CLLocationCoordinate2D *)coords count:(NSUInteger)count;

/// 重新设置路名对象坐标点
/// @param points  指定的直角坐标点数组
/// @param count points数组中坐标点的个数
/// @return 是否设置成功
- (BOOL)setTextPathMarkerWithPoints:(BMKMapPoint *)points count:(NSUInteger)count;

/// 重新设置路名对象坐标点
/// @param coords 指定的经纬度坐标点数组
/// @param count coords数组中坐标点的个数
/// @return 是否设置成功
- (BOOL)setTextPathMarkerWithCoordinates:(CLLocationCoordinate2D *)coords count:(NSUInteger)count;
@end

NS_ASSUME_NONNULL_END
