//
//  BMKRichView.h
//  MapComponent
//
//  Created by zhaoxiangru on 2024/3/12.
//  Copyright © 2024 Baidu. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "BMKBaseUIView.h"
#import "BMKCommonDef.h"
#import "BMKMapAnimation.h"
#import "BMKRichUIOption.h"
NS_ASSUME_NONNULL_BEGIN

@interface BMKRichView : NSObject
@property (nonatomic, strong) BMKBaseUIView        *rootView;
@property (nonatomic, assign) BMKVisibility   visibility;
@property (nonatomic, assign) float             opacity;        // [0, 1.0]
@property (nonatomic, strong, nullable) BMKMapAnimation *animation;
@property (nonatomic, assign) BMKLocate       locate;         // The location relative to it's parent marker.
@property (nonatomic, assign) int               offsetX;        // 偏离Located 多少point（屏幕坐标系，向左「-」、向右「+」)
@property (nonatomic, assign) int               offsetY;        // 偏离Located 多少point（屏幕坐标系，向上「-」、向下「+」)
// RichView的碰撞避让行为；动画中不支持；BMKCollisionBehavior类型，默认为BMKCollisionNotCollide：不参与;
@property (nonatomic, assign) BMKCollisionBehavior collisionBehavior;
/**
 * The Collision Priority of this view.
 * It is useful when 「CollisionBehavior == HIDE_BY_PRIORITY」
 *
 * note: RichView.priority <= it's parent.priority
 */
// RichView的优先级不能超过其ParentMarker;RichView即使设置为alwaysshow，只要Marker没设置为alwaysshow，RichView的优先级还是会被置为Marker的优先级
@property (nonatomic, assign) int         collisionPriority;
@property (nonatomic, assign) UIEdgeInsets           collisionBorder;       // The Collision Border of this view.
@property (nonatomic, assign) int                    collisionLineTagId;    // 与指定的Line进行避让 [lineTagId == 0 不避让]

@property (nonatomic, assign) float scaleX;
@property (nonatomic, assign) float scaleY;

@property (nonatomic, strong) NSString *name;
@property (nonatomic, strong) NSString *tag;
@property (nonatomic, strong) NSString *descript;

/**
  *  Just for parse PB of XML_POP.
  *
  * @param pbVisibility {0 1 2}
  */
- (void)setPBVisibility:(int)pbVisibility;

// 添加BMKRichUIOption配置参与碰撞避让的UI（BMKBaseUIView，一般为rootView）的可选方位
- (BOOL)addRichUIOption:(BMKRichUIOption *)richUIOption;
- (BOOL)delRichUIOption:(BMKRichUIOption *)richUIOption;

/**
 * Set the show/hide state of this View. [from, to]
 *
 *  @param from : Min_Level 3
 *  @param to   : Max_Level 22
 */
- (BOOL)setShowLevel:(int)from toLevel:(int)to;

- (nullable BMKRichView *)findRichViewWithName:(nonnull NSString *)name;

- (nullable BMKRichView *)findViewWithName:(nonnull NSString *)name;
@end

NS_ASSUME_NONNULL_END
