/*
 *  BMKPolygonView.h
 *  BMapKit
 *
 *  Copyright 2011 Baidu Inc. All rights reserved.
 *
 */

#import "BMKGeometryView.h"
#import "BMKPolygon.h"


NS_ASSUME_NONNULL_BEGIN
/// 此类用于定义一个多边形View
@interface BMKPolygonView : BMKGeometryView

/// 根据指定的多边形生成一个多边形View
/// @param polygon 指定的多边形数据对象
/// @return 新生成的多边形View
- (nullable instancetype)initWithPolygon:(BMKPolygon *)polygon;

/// 该View对应的多边形数据
@property (nonatomic, readonly) BMKPolygon *polygon;

/// 是否可点击，默认NO
@property (assign, nonatomic) BOOL isClickable;

/// 镂空区域是否可点击，默认NO：点中镂空区域时不触发该overlay的点击回调
@property (assign, nonatomic) BOOL isHoleClickable;

/// isHoleClickable为YES时，触发回调的镂空索引值，默认-1:点中的是非镂空区域;索引对应polygon.hollowShapes,倒序遍历，即优先触发后添加的镂空
@property (assign, nonatomic) NSInteger holeClickedIndex;

/// 发光模式，仅支持颜色实折线；since 6.6.3
/// 默认不发光，kBMKLineBloomModeNone
@property (nonatomic, assign) BMKLineBloomMode lineBloomMode;

/// 默认向两侧发光，kBMKLineBloomDirectionAround； since 6.6.3
@property (nonatomic, assign) BMKLineBloomDirection lineBloomDirection;

/// 发光处宽度，默认 0.0f；since 6.6.3
@property (nonatomic, assign) CGFloat lineBloomWidth;

/// 发光处透明度，取值范围 [0 ~ 255]，默认 255.0f；since 6.6.3
@property (nonatomic, assign) CGFloat lineBloomAlpha;

/// 透明度渐变速度 since 6.6.3
/// 取值范围 [1.0f ~ 10.0f]，默认值为 5.0f
/// 注意：渐变发光模式下该属性生效
@property (nonatomic, assign) CGFloat lineBloomGradientASPeed;

/// 模糊次数 since 6.6.3
/// 取值范围 [1~10]，默认值为 1
/// 注意：模糊发光模式下该属性生效
@property (nonatomic, assign) int lineBloomBlurTimes;

@end
NS_ASSUME_NONNULL_END
