//
//  BMKGroupUIView.h
//  MapComponent
//
//  Created by zhaoxiangru on 2024/3/12.
//  Copyright © 2024 Baidu. All rights reserved.
//

#import "BMKBaseUIView.h"

NS_ASSUME_NONNULL_BEGIN

@interface BMKGroupUIView : BMKBaseUIView
@property(nonatomic, strong, readonly) NSArray<BMKBaseUIView *>* childs;
- (BOOL)addView:(BMKBaseUIView *)view;
- (BOOL)insertView:(BMKBaseUIView *)view atIndex:(NSInteger)index;
@end

/**
 *  控件的水平布局 for 复杂布局
 */
@interface BMKHorizontalLayout : BMKGroupUIView

@end

/**
 *  控件的垂直布局 for 复杂布局
 */
@interface BMKVerticalLayout : BMKGroupUIView

@end

/**
 *  控件的叠加布局 for 复杂布局
 */
@interface BMKFrameLayout : BMKGroupUIView

@end

NS_ASSUME_NONNULL_END
