//
//  BMKGeometryView.h
//  MapComponent
//
//  Created by zhangbaojin on 2021/7/28.
//  Copyright © 2021 Baidu. All rights reserved.
//

#import "BMKOverlayGLBasicView.h"

NS_ASSUME_NONNULL_BEGIN
/// 该类定义了一个用opengl绘制geometry的基类
@interface BMKGeometryView : BMKOverlayGLBasicView

/// 填充颜色
/// 注：请使用 - (UIColor *)initWithRed:(CGFloat)red green:(CGFloat)green blue:(CGFloat)blue alpha:(CGFloat)alpha; 初始化UIColor。
/// 使用[UIColor ***Color]初始化时，个别case转换成RGB后会有问题
@property (nonatomic, strong, nullable) UIColor *fillColor;

/// 画笔颜色
/// 注：请使用 - (UIColor *)initWithRed:(CGFloat)red green:(CGFloat)green blue:(CGFloat)blue alpha:(CGFloat)alpha; 初始化UIColor。
/// 使用[UIColor ***Color]初始化时，个别case转换成RGB后会有问题
@property (nonatomic, strong, nullable) UIColor *strokeColor;
/// 加载绘制当前进度之前的部分的画笔颜色，不设置时当前进度之前的路线不显示，轨迹动画化使用 since 6.6.3
@property (nonatomic, strong, nullable) UIColor *strokeColorProgressForward;
/// 加载绘制当前进度之后的部分的画笔颜色，不设置时当前进度之后的路线不显示，轨迹动画化使用 since 6.6.3
@property (nonatomic, strong, nullable) UIColor *strokeColorProgressBackward;

/// 画笔宽度，默认为0
@property (nonatomic, assign) CGFloat lineWidth;

/// 虚线类型, since 5.0.0，默认kBMKLineDashTypeNone (仅支持颜色虚线)
@property (nonatomic, assign) BMKLineDashType lineDashType;

@end
NS_ASSUME_NONNULL_END
