//
//  BMKGeodesicLineView.h
//  MapComponent
//
//  Created by zhangbaojin on 2021/3/23.
//  Copyright © 2021 Baidu. All rights reserved.
//

#import "BMKGeometryView.h"
#import "BMKGeodesicLine.h"

NS_ASSUME_NONNULL_BEGIN
/// 此类用于定义一个大地曲线View since 6.3.0
@interface BMKGeodesicLineView : BMKGeometryView

/// 根据指定的大地曲线生成一个大地曲线View
/// @param geodesicLine 指定的大地曲线数据对象
/// @return 新生成的大地曲线View
- (nullable instancetype)initWithGeodesicLine:(BMKGeodesicLine *)geodesicLine;

/// 该View对应的大地曲线数据对象
@property (nonatomic, readonly) BMKGeodesicLine *geodesicLine;

/// 是否可点击，默认YES
@property (assign, nonatomic) BOOL isClickable;

/// 发光模式，仅支持颜色实折线；since 6.6.3
/// 默认不发光，kBMKLineBloomModeNone
@property (nonatomic, assign) BMKLineBloomMode lineBloomMode;

/// 默认向两侧发光，kBMKLineBloomDirectionAround； since 6.6.3
@property (nonatomic, assign) BMKLineBloomDirection lineBloomDirection;

/// 发光处宽度，默认 0.0f；since 6.6.3
@property (nonatomic, assign) CGFloat lineBloomWidth;

/// 发光处透明度，取值范围 [0 ~ 255]，默认 255.0f；since 6.6.3
@property (nonatomic, assign) CGFloat lineBloomAlpha;

/// 透明度渐变速度 since 6.6.3
/// 取值范围 [1.0f ~ 10.0f]，默认值为 5.0f
/// 注意：渐变发光模式下该属性生效
@property (nonatomic, assign) CGFloat lineBloomGradientASPeed;

/// 模糊次数 since 6.6.3
/// 取值范围 [1~10]，默认值为 1
/// 注意：模糊发光模式下该属性生效
@property (nonatomic, assign) int lineBloomBlurTimes;
@end

NS_ASSUME_NONNULL_END
